% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/db_updates.R
\name{db_updates}
\alias{db_updates}
\title{Get information on database updates}
\usage{
db_updates(cushion, feed = "longpoll", timeout = 60, heartbeat = TRUE,
  as = "list", ...)
}
\arguments{
\item{cushion}{A \code{Cushion} object. Required.}

\item{feed}{(character) One of longpoll (default), continuous, or
eventsource. See Details.}

\item{timeout}{(integer) Number of seconds until CouchDB closes the
connection. Default: 60.}

\item{heartbeat}{(logical) Whether CouchDB will send a newline character
on timeout. Default: \code{TRUE}}

\item{as}{(character) One of list (default) or json}

\item{...}{Curl args passed on to one of the HTTP verbs (e.g,.
\code{\link[httr]{GET}}, \code{\link[httr]{POST}}, \code{\link[httr]{PUT}},
etc.)}
}
\value{
JSON as a character string or a list (determined by the
\code{as} parameter)
}
\description{
Get information on database updates
}
\details{
This may not be very appropriate for use in R, but who knows,
so here it is.

Also, continuous and eventsource don't seem to work in R, unless I'm
missing something.

Options for the \code{feed} parmeter:
\itemize{
 \item longpoll: Closes the connection after the first event.
 \item continuous: Send a line of JSON per event. Keeps the socket open
 until timeout.
 \item eventsource: Like, continuous, but sends the events in EventSource
 format.
}
}
\examples{
\dontrun{
(x <- Cushion$new())

db_updates(x)
db_updates(x, feed="continuous")
db_updates(x, feed="eventsource")
}
}

