% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/soc_metadata.R
\name{soc_metadata}
\alias{soc_metadata}
\title{Extract Socrata Dataset Metadata}
\usage{
soc_metadata(dataset)
}
\arguments{
\item{dataset}{A tibble returned by \code{soc_read()} or a url.}
}
\value{
An object of class \code{soc_meta}, which includes:
\describe{
\item{id}{Asset identifier (four-by-four ID).}
\item{name}{Asset name.}
\item{attribution}{Attribution or publisher of the asset.}
\item{owner_name}{Display name of the asset owner.}
\item{provenance}{Provenance of asset (official or community).}
\item{description}{Textual description of the asset.}
\item{created}{Date asset was created.}
\item{data_last_updated}{Date asset data was last updated}
\item{metadata_last_updated}{Date asset metadata was last updated}
\item{domain_category}{Category label assigned by the domain.}
\item{domain_tags}{Tags applied by the domain.}
\item{domain_metadata}{Metadata associated with the asset assigned by the domain.}
\item{columns}{A dataframe with the following columns:
\describe{
\item{column_name}{Names of asset columns.}
\item{column_label}{Labels of asset columns.}
\item{column_datatype}{Datatypes of asset columns.}
\item{column_description}{Description of asset columns.}
}
}
\item{permalink}{Permanent URL where the asset can be accessed.}
\item{link}{Direct asset link.}
\item{license}{License associated with the asset.}
}
}
\description{
Retrieves metadata attributes from a tibble returned by \code{soc_read()} or using the dataset url, including
dataset-level information and column-level descriptions.
}
\details{
This function pulls out descriptive metadata such as the dataset's ID, title, attribution, category,
creation and update timestamps, description, any domain-specific fields, and field descriptions defined by the
data provider.
}
\examples{
\donttest{
url <- "https://soda.demo.socrata.com/dataset/USGS-Earthquakes-2012-11-08/3wfw-mdbc/"
data <- soc_read(url, soc_query(limit = 1000L))
metadata <- soc_metadata(data)
print(metadata)

metadata <- soc_metadata(url)
print(metadata)
}

}
