% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_geoids.R
\name{get_geoids}
\alias{get_geoids}
\title{Obtain GEOIDs of areas}
\usage{
get_geoids(
  geography,
  state = NULL,
  county = NULL,
  geoid = NULL,
  year = 2010,
  geometry = FALSE,
  cache_tables = TRUE,
  key = NULL,
  ...
)
}
\arguments{
\item{geography}{A character string denoting the level of census geography
whose GEOIDs you'd like to obtain. Must be one of \code{c("state", "county", "tract", "block group", "block")}.

Note that block-level data cannot be obtained from 1990 and 2000 decennial
census data due to limitations in \code{\link[tidycensus:get_decennial]{tidycensus::get_decennial()}}. Whereas
block-level 2010 decennial census data are available, block-level ADI and
ADI-3 cannot be calculated due to the removal of the long-form
questionnaire from the 2010 decennial census.}

\item{state, county, geoid, geometry, cache_tables, key}{See the descriptions of
the arguments in \code{\link[=get_adi]{get_adi()}}.}

\item{year}{Single integer specifying the year of US Census data to use.
Defaults to 2010. Based on this year, data from the most recent decennial
census will be returned (specifically, \verb{year <- }\code{\link{floor}}\code{(year / 10) * 10} is run).}

\item{...}{Additional arguments to be passed to
\code{\link[tidycensus:get_decennial]{tidycensus::get_decennial()}}. Use at your own risk.}
}
\description{
Returns a \code{\link[tibble:tibble]{tibble}} or \code{\link[sf:sf]{sf}} of GEOIDs, names, and
decennial census population of user-specified locations.
}
\details{
This allows users to quickly obtain all GEOIDs in a specified location at a
specific level of geography without having to manually look them up somewhere
else.

This facilitates calls to \code{\link[=get_adi]{get_adi()}} that involve somewhat complicated
reference areas.
}
\examples{
\dontrun{
# Wrapped in \dontrun{} because it requires a Census API key.

# Get all tract GEOIDs for Manhattan
tracts <- get_geoids(geography = "tract", state = "New York", county = "New York")
tracts

# Get all block GEOIDs for the fifth tract on that list
get_geoids(geography = "block", geoid = tracts$GEOID[5])
}
}
