% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggplots_ld.R
\name{ggplot_ld}
\alias{ggplot_ld}
\title{Ggplot linkage disequilibrium}
\usage{
ggplot_ld(
  df_ld,
  diamonds = length(unique(df_ld$SNP_A)) < 40,
  point_size = 120/sqrt(nrow(df_ld)),
  reverse = FALSE,
  reindex = TRUE
)
}
\arguments{
\item{df_ld}{Data frame with columns SNP_A, SNP_B, and R2.
As returned by the snprelate_ld function.}

\item{diamonds}{Should the values be displayed as diamonds or points ?
Default is TRUE for less than 40 SNPs.}

\item{point_size}{Size for geom_point. Ignored if diamonds is TRUE.}

\item{reverse}{Reverse the display (horizontal symmetry)}

\item{reindex}{If FALSE, SNPs are positionned following their IDs}
}
\value{
ggplot
}
\description{
Display SNP r2 correlations using points or diamonds with text.
}
