% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api-grid.R
\name{snic_grid_manual}
\alias{snic_grid_manual}
\title{Interactive seed selection for SNIC segmentation}
\usage{
snic_grid_manual(
  x,
  seeds = NULL,
  ...,
  snic_args = list(compactness = 0.5),
  snic_plot_args = list(stretch = "lin", seeds_plot_args = list(pch = 4, col = "#FFFF00",
    cex = 1), seg_plot_args = list(border = "#FFFF00", col = NA, lwd = 0.4))
)
}
\arguments{
\item{x}{A \code{\link[terra:SpatRaster-class]{SpatRaster}} object
with a valid spatial reference and extent. Mouse clicks are interpreted
in map coordinates.}

\item{seeds}{Optional existing seed set to display and extend.
If pixel coordinates are supplied, they are internally converted. If
\code{NULL}, the seed set is initialized empty and populated
interactively.}

\item{...}{Arguments forwarded to \code{\link{snic_plot}} for display
control. These may include \code{band}, \code{r}, \code{g}, \code{b},
\code{stretch}, \code{seeds_plot_args}, or \code{seg_plot_args}.}

\item{snic_args}{A list of arguments passed to \code{\link{snic}}, such as
\code{compactness}.}

\item{snic_plot_args}{A list of display modifiers forwarded to
\code{\link{snic_plot}} when rendering the preview.}
}
\value{
A two-column data frame of seed coordinates. If \code{x} lacks a CRS the
result is always pixel indices \code{(r, c)}. When \code{x} has a CRS:
\itemize{
  \item If \code{seeds} were supplied, their coordinate system is preserved
    in the output.
  \item Otherwise the result is expressed as \code{(lat, lon)} in
    \code{EPSG:4326}.
}
The output can be passed directly to \code{\link{snic}}.
}
\description{
Collect seed points interactively by clicking on the image. Each left-click
adds a new seed; pressing \code{ESC} ends the session. After each click,
SNIC segmentation is recomputed and plotted for visual feedback. This is
intended for exploratory and fine-tuning workflows, where automatic seeding
may not be ideal.
}
\details{
After each new seed is placed interactively, segmentation is recomputed to
provide immediate feedback on how the seed placement affects clustering.
}
\examples{
if (interactive() && requireNamespace("terra", quietly = TRUE)) {
    tiff_dir <- system.file("demo-geotiff",
        package = "snic",
        mustWork = TRUE
    )
    files <- file.path(
        tiff_dir,
        c(
            "S2_20LMR_B02_20220630.tif",
            "S2_20LMR_B04_20220630.tif",
            "S2_20LMR_B08_20220630.tif",
            "S2_20LMR_B12_20220630.tif"
        )
    )
    s2 <- terra::aggregate(terra::rast(files), fact = 8)

    seeds <- snic_grid_manual(
        s2,
        snic_args = list(compactness = 0.1),
        snic_plot_args = list(r = 4, g = 3, b = 1)
    )

    seg <- snic(s2, seeds, compactness = 0.1)

    snic_plot(
        s2,
        r = 4, g = 3, b = 1,
        stretch = "lin",
        seeds = seeds,
        seg = seg
    )
}
}
\seealso{
\code{\link{snic}}, \code{\link{snic_grid}}, \code{\link{snic_animation}}.
}
