% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/caseconverters.R
\name{caseconverter}
\alias{caseconverter}
\alias{to_snake_case}
\alias{to_lower_camel_case}
\alias{to_upper_camel_case}
\alias{to_screaming_snake_case}
\alias{to_parsed_case}
\alias{to_mixed_case}
\alias{to_lower_upper_case}
\alias{to_upper_lower_case}
\alias{to_swap_case}
\title{Specific case converter shortcuts}
\usage{
to_snake_case(string, abbreviations = NULL, sep_in = NULL,
  parsing_option = 1, transliterations = NULL, sep_out = NULL,
  unique_sep = NULL, empty_fill = NULL, prefix = "", postfix = "")

to_lower_camel_case(string, abbreviations = NULL, sep_in = NULL,
  parsing_option = 1, transliterations = NULL, sep_out = NULL,
  unique_sep = NULL, empty_fill = NULL, prefix = "", postfix = "")

to_upper_camel_case(string, abbreviations = NULL, sep_in = NULL,
  parsing_option = 1, transliterations = NULL, sep_out = NULL,
  unique_sep = NULL, empty_fill = NULL, prefix = "", postfix = "")

to_screaming_snake_case(string, abbreviations = NULL, sep_in = NULL,
  parsing_option = 1, transliterations = NULL, sep_out = NULL,
  unique_sep = NULL, empty_fill = NULL, prefix = "", postfix = "")

to_parsed_case(string, abbreviations = NULL, sep_in = NULL,
  parsing_option = 1, transliterations = NULL, sep_out = NULL,
  unique_sep = NULL, empty_fill = NULL, prefix = "", postfix = "")

to_mixed_case(string, abbreviations = NULL, sep_in = NULL,
  parsing_option = 1, transliterations = NULL, sep_out = NULL,
  unique_sep = NULL, empty_fill = NULL, prefix = "", postfix = "")

to_lower_upper_case(string, abbreviations = NULL, sep_in = NULL,
  parsing_option = 1, transliterations = NULL, sep_out = NULL,
  unique_sep = NULL, empty_fill = NULL, prefix = "", postfix = "")

to_upper_lower_case(string, abbreviations = NULL, sep_in = NULL,
  parsing_option = 1, transliterations = NULL, sep_out = NULL,
  unique_sep = NULL, empty_fill = NULL, prefix = "", postfix = "")

to_swap_case(string, abbreviations = NULL, sep_in = NULL,
  parsing_option = 1, transliterations = NULL, sep_out = NULL,
  unique_sep = NULL, empty_fill = NULL, prefix = "", postfix = "")
}
\arguments{
\item{string}{A string (for example names of a data frame).}

\item{abbreviations}{character with (uppercase) abbreviations. This marks
abbreviations with an underscore behind (in front of the parsing).
Useful if \code{parsing_option} 1 is needed, but some abbreviations within the string need \code{parsing_option} 2.
Use this feature with care: One letter abbreviations and abbreviations next to each other may not be handled correctly, since those cases would introduce ambiguity in parsing.}

\item{sep_in}{(short for separator input) A regex supplied as a character (if not \code{NULL}), which will be wrapped internally
into \code{stringr::regex()}. All matches will be replaced by underscores. Underscores can later turned into another separator via \code{sep_out}.}

\item{parsing_option}{An integer that will determine the parsing_option.
\itemize{
 \item{1: \code{RRRStudio -> RRR_Studio}}
 \item{2: \code{RRRStudio -> RRRS_tudio}}
 \item{3: parses like option 1 but suppresses "_" around non special characters.
 In this way case conversion won't apply after these characters. See examples.}
 \item{4: parses like option 1, but digits directly behind/in front non-digits, will stay as is.}
 \item{any other integer <= 0: no parsing"}
 }}

\item{transliterations}{A character vector (if not \code{NULL}). The entries of this argument
need to be elements of \code{stringi::stri_trans_list()} (like "Latin-ASCII", which is often useful) or names of lookup tables (currently
only "german" is supported). In the order of the entries the letters of the input
 string will be transliterated via \code{stringi::stri_trans_general()} or replaced via the 
 matches of the lookup table.
 
You should use this feature with care in case of \code{case = "parsed"}, \code{case = "internal_parsing"} and 
\code{case = "none"}, since for upper case letters, which have transliterations/replacements
 of length 2, the second letter will be transliterated to lowercase, for example Oe, Ae, Ss, which
 might not always be what is intended.}

\item{sep_out}{(short for separator output) String that will be used as separator. The defaults are \code{"_"} 
and \code{""}, regarding the specified \code{case}.}

\item{unique_sep}{A string. If not \code{NULL}, then duplicated names will get 
a suffix integer
in the order of their appearance. The suffix is separated by the supplied string
 to this argument.}

\item{empty_fill}{A string. If it is supplied, then each entry that matches "" will be replaced
by the supplied string to this argument.}

\item{prefix}{prefix (string).}

\item{postfix}{postfix (string).}
}
\value{
A character vector according the specified parameters above.

A character vector according the specified target case.
}
\description{
Wrappers around \code{to_any_case()}
}
\note{
caseconverters are vectorised over \code{string}, \code{sep_in}, \code{sep_out},
 \code{empty_fill}, \code{prefix} and \code{postfix}.
}
\examples{
strings <- c("this Is a Strange_string", "AND THIS ANOTHER_One", NA)

to_snake_case(strings)
to_lower_camel_case(strings)
to_upper_camel_case(strings)
to_screaming_snake_case(strings)
to_lower_upper_case(strings)
to_upper_lower_case(strings)
to_parsed_case(strings)
to_mixed_case(strings)
to_swap_case(strings)


}
\seealso{
\href{https://github.com/Tazinho/snakecase}{snakecase on github}, \code{\link{to_any_case}} for flexible high level conversion and more examples.
}
\author{
Malte Grosser, \email{malte.grosser@gmail.com}

Malte Grosser, \email{malte.grosser@gmail.com}
}
\keyword{utilities}
