% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/isFunctions.R, R/msdecompose.R
\name{is.smooth}
\alias{is.smooth}
\alias{is.smoothC}
\alias{is.msarima}
\alias{is.oes}
\alias{is.oesg}
\alias{is.smooth.sim}
\alias{is.smooth.forecast}
\alias{is.adam}
\alias{is.adam.sim}
\alias{is.msdecompose}
\alias{is.msdecompose.forecast}
\title{Smooth classes checkers}
\usage{
is.smooth(x)

is.smoothC(x)

is.msarima(x)

is.oes(x)

is.oesg(x)

is.smooth.sim(x)

is.smooth.forecast(x)

is.adam(x)

is.adam.sim(x)

is.msdecompose(x)

is.msdecompose.forecast(x)
}
\arguments{
\item{x}{The object to check.}
}
\value{
\code{TRUE} if this is the specified class and \code{FALSE} otherwise.

\code{TRUE} if this is the specified class and \code{FALSE} otherwise.
}
\description{
Functions to check if an object is of the specified class

Functions to check if an object is of the specified class
}
\details{
The list of functions includes:
\itemize{
\item \code{is.smooth()} tests if the object was produced by a smooth function
(e.g. \link[smooth]{es} / \link[smooth]{ces} / \link[smooth]{ssarima} /
\link[smooth]{gum} / \link[smooth]{sma} / \link[smooth]{msarima});
\item \code{is.msarima()} tests if the object was produced by the
\link[smooth]{msarima} function;
\item \code{is.smoothC()} tests if the object was produced by a combination
function (currently applies only to \link[smooth]{smoothCombine});
\item \code{is.oes()} tests if the object was produced by \link[smooth]{oes}
function;
\item \code{is.smooth.sim()} tests if the object was produced by simulate functions
(e.g. \link[smooth]{sim.es} / \link[smooth]{sim.ces} / \link[smooth]{sim.ssarima}
/ \link[smooth]{sim.sma} / \link[smooth]{sim.gum});
\item \code{is.smooth.forecast()} checks if the forecast was produced from a smooth
function using forecast() function.
}

The list of functions includes:
\itemize{
\item \code{is.adam()} tests if the object was produced by a \link[smooth]{adam} function
\item \code{is.adam.sim()} tests if the object was produced by sim.adam() function (not implemented yet);
}
}
\examples{

ourModel <- msarima(rnorm(100,100,10))

is.smooth(ourModel)
is.msarima(ourModel)


ourModel <- adam(rnorm(100,100,10))
is.adam(ourModel)

}
\author{
Ivan Svetunkov, \email{ivan@svetunkov.ru}

Ivan Svetunkov, \email{ivan@svetunkov.ru}
}
\keyword{ts}
\keyword{univar}
