% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simssarima.R
\name{sim.ssarima}
\alias{sim.ssarima}
\title{Simulate SSARIMA}
\usage{
sim.ssarima(orders = list(ar = 0, i = 1, ma = 1), lags = 1, obs = 10,
  nsim = 1, frequency = 1, AR = NULL, MA = NULL, constant = FALSE,
  initial = NULL, bounds = c("admissible", "none"),
  randomizer = c("rnorm", "rt", "rlaplace", "rs"), iprob = 1, ...)
}
\arguments{
\item{orders}{List of orders, containing vector variables \code{ar},
\code{i} and \code{ma}. Example:
\code{orders=list(ar=c(1,2),i=c(1),ma=c(1,1,1))}. If a variable is not
provided in the list, then it is assumed to be equal to zero. At least one
variable should have the same length as \code{lags}.}

\item{lags}{Defines lags for the corresponding orders (see examples above).
The length of \code{lags} must correspond to the length of \code{orders}.
There is no restrictions on the length of \code{lags} vector.
It is recommended to order \code{lags} ascending.}

\item{obs}{Number of observations in each generated time series.}

\item{nsim}{Number of series to generate (number of simulations to do).}

\item{frequency}{Frequency of generated data. In cases of seasonal models
must be greater than 1.}

\item{AR}{Vector or matrix of AR parameters. The order of parameters should
be lag-wise. This means that first all the AR parameters of the firs lag
should be passed, then for the second etc. AR of another ssarima can be
passed here.}

\item{MA}{Vector or matrix of MA parameters. The order of parameters should
be lag-wise. This means that first all the MA parameters of the firs lag
should be passed, then for the second etc. MA of another ssarima can be
passed here.}

\item{constant}{If \code{TRUE}, constant term is included in the model. Can
also be a number (constant value).}

\item{initial}{Vector of initial values for state matrix. If \code{NULL},
then generated using advanced, sophisticated technique - uniform
distribution.}

\item{bounds}{Type of bounds to use for AR and MA if values are generated.
\code{"admissible"} - bounds guaranteeing stability and stationarity of
SSARIMA. \code{"none"} - we generate something, but do not guarantee
stationarity and stability. Using first letter of the type of bounds also
works.}

\item{randomizer}{Type of random number generator function used for error
term. Defaults are: \code{rnorm}, \code{rt}, \code{rlaplace} and \code{rs}.
\code{rlnorm} should be used for multiplicative models (e.g. ETS(M,N,N)).
But any function from \link[stats]{Distributions} will do the trick if the
appropriate parameters are passed. For example \code{rpois} with
\code{lambda=2} can be used as well, but might result in weird values.}

\item{iprob}{Probability of occurrence, used for intermittent data
generation. This can be a vector, implying that probability varies in time
(in TSB or Croston style).}

\item{...}{Additional parameters passed to the chosen randomizer. All the
parameters should be passed in the order they are used in chosen randomizer.
For example, passing just \code{sd=0.5} to \code{rnorm} function will lead
to the call \code{rnorm(obs, mean=0.5, sd=1)}.}
}
\value{
List of the following values is returned:
\itemize{
\item \code{model} - Name of SSARIMA model.
\item \code{AR} - Value of AR parameters. If \code{nsim>1}, then this is a
matrix.
\item \code{MA} - Value of MA parameters. If \code{nsim>1}, then this is a
matrix.
\item \code{constant} - Value of constant term. If \code{nsim>1}, then this
is a vector.
\item \code{initial} - Initial values of SSARIMA. If \code{nsim>1}, then this
is a matrix.
\item \code{data} - Time series vector (or matrix if \code{nsim>1}) of the
generated series.
\item \code{states} - Matrix (or array if \code{nsim>1}) of states. States
are in columns, time is in rows.
\item \code{residuals} - Error terms used in the simulation. Either vector or
matrix, depending on \code{nsim}.
\item \code{occurrence} - Values of occurrence variable. Once again, can be
either a vector or a matrix...
\item \code{logLik} - Log-likelihood of the constructed model.
}
}
\description{
Function generates data using SSARIMA with Single Source of Error as a data
generating process.
}
\details{
For the information about the function, see the vignette:
\code{vignette("simulate","smooth")}
}
\examples{

# Create 120 observations from ARIMA(1,1,1) with drift. Generate 100 time series of this kind.
x <- sim.ssarima(ar.orders=1,i.orders=1,ma.orders=1,obs=120,nsim=100,constant=TRUE)

# Generate similar thing for seasonal series of SARIMA(1,1,1)(0,0,2)_4
x <- sim.ssarima(ar.orders=c(1,0),i.orders=c(1,0),ma.orders=c(1,2),lags=c(1,4),
                 frequency=4,obs=80,nsim=100,constant=FALSE)

# Generate 10 series of high frequency data from SARIMA(1,0,2)_1(0,1,1)_7(1,0,1)_30
x <- sim.ssarima(ar.orders=c(1,0,1),i.orders=c(0,1,0),ma.orders=c(2,1,1),lags=c(1,7,30),
                 obs=360,nsim=10)


}
\references{
\itemize{
\item Snyder, R. D., 1985. Recursive Estimation of Dynamic Linear Models.
Journal of the Royal Statistical Society, Series B (Methodological) 47 (2), 272-276.
\item Hyndman, R.J., Koehler, A.B., Ord, J.K., and Snyder, R.D. (2008)
Forecasting with exponential smoothing: the state space approach,
Springer-Verlag. \url{http://dx.doi.org/10.1007/978-3-540-71918-2}.
}

\itemize{
\item Svetunkov, I., & Boylan, J. E. (2019). State-space ARIMA for supply-chain forecasting.
International Journal of Production Research, 0(0), 1–10.
\url{https://doi.org/10.1080/00207543.2019.1600764}
}
}
\seealso{
\code{\link[smooth]{sim.es}, \link[smooth]{ssarima},
\link[stats]{Distributions}, \link[smooth]{orders}, \link[smooth]{lags}}
}
\author{
Ivan Svetunkov, \email{ivan@svetunkov.ru}
}
\keyword{models}
\keyword{nonlinear}
\keyword{regression}
\keyword{smooth}
\keyword{ts}
\keyword{univar}
