% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{penalty}
\alias{penalty}
\title{Penalty function on the composite L2, L2-Square, and L1 penalties}
\usage{
penalty(x, lambda, hierarchy, d)
}
\arguments{
\item{x}{A vector of two numeric values, in which \eqn{x_1} represents
the prognostic effect, and \eqn{x_2} for the predictive effect, 
respectively.}

\item{lambda}{a vector of three penalty parameters. \eqn{\lambda_1} and 
\eqn{\lambda_2} are L2 and L2-Square (ridge) penalties for \eqn{x} in 
a group level, and \eqn{\lambda_3} is the L1 penalty for \eqn{x_2}, respectively.}

\item{hierarchy}{a factor value in levels 0, 1, 2, which represent different
hierarchical structure in x, respectively. When \code{hierarchy=0},
\eqn{\lambda_2} and \eqn{\lambda_3} are forced to be zeroes; when
\code{hierarchy=1}, \eqn{\lambda_2} is forced to be zero; when 
\code{hierarchy=2}, there is no constraint on \eqn{\lambda}'s. 
See \code{\link{smog}}.}

\item{d}{indices for overlapped variables in x.}
}
\value{
A numeric value of the penalty function based on the composition of L2, L2-Square,
        and L2 penalties.
}
\description{
Penalty function on the composite L2, L2-Square, and L1 penalties
}
\examples{
penalty(x = rnorm(6,2,1), lambda = c(0.5,0.3,0.1), hierarchy = 0, d = c(1,1,2,2,3,3))        

}
\references{
\insertRef{ma2019structural}{smog}
}
\seealso{
\code{\link{cv.smog}}, \code{\link{smog.default}}, \code{\link{smog.formula}}, 
         \code{\link{predict.smog}}, \code{\link{plot.smog}}.
}
\author{
Chong Ma, \email{chongma8903@gmail.com}.
}
