% Generated by roxygen2 (4.0.2): do not edit by hand
\name{sampleIn}
\alias{sampleIn}
\alias{sampleIn,Grid-method}
\alias{sampleIn,data.frame-method}
\alias{sampleIn,matrix-method}
\title{Sample from/in a design object}
\usage{
sampleIn(X, size = 1L, atSample = FALSE, ...)
}
\arguments{
\item{X}{The object, typically a design matrix with class
\code{matrix} or an object with class \code{"Grid"}.}

\item{size}{Number of sample points.}

\item{atSample}{Logical. If \code{TRUE} the new sample points are
obtained using \code{sample}}

\item{...}{Other arguments to be passed to the \code{sample} function
when \code{atSample} is \code{TRUE}, typically \code{replace = TRUE}
is needed when the object \code{x} contains less than the target
number given in \code{size}.}
}
\value{
A matrix with \code{size} rows. When \code{atSample} is
\code{TRUE}, the matrix has an attribute named \code{index} which
gives the position of the sampled items in the original grid.
}
\description{
Sample from/in a design object.
}
\details{
From the object, \code{size} 'new' design points are sampled or
drawn. When \code{atSample} is \code{FALSE}, the range of each
column is computed or extracted from the object \code{x}, and then
independent drawings from the corresponding uniform distributions
are used.
}
\note{
When \code{x} is of class \code{"Grid"}, it may be the case
that the drawings with \code{atSample = FALSE} have no meaning since some
of the variables may be discrete variables and not continuous ones.
}
\examples{
g <- Grid(levels = list("Temp" = c(400, 450, 500),
                        "Bore" = c(0, 600, 1200, 1800, 2400)))
X1 <- sampleIn(g, size = 4)
X2 <- sampleIn(g, size = 4, atSample = TRUE)

## this must be zero
sum(abs(as.matrix(g)[attr(X2, "index"), ] - X2))
}
\seealso{
The \code{\link{sample}} function.
}

