% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{mat_cov}
\alias{mat_cov}
\title{Matern covariance function for a given distance matrix.}
\usage{
mat_cov(dists, sigsq, phi, nu)
}
\arguments{
\item{dists}{a numeric matrix representing the distance between spatial
entities.}

\item{sigsq}{the \eqn{\sigma^2} parameter from the Matern covariance
function.}

\item{phi}{the \eqn{\phi} parameter from the Matern covariance function,
controls the range of the spatial dependence.}

\item{nu}{the \eqn{\nu} parameter from the Matern covariance function,
controls the differentiability of the process.}
}
\value{
The matern covariance function (for a stationary and isotropic
process) associated with the provided distances (\code{dists}) and the
given set of parameters.
}
\description{
Computing the Matern covariance function for a matrix of
distances.
}
\seealso{
\code{\link{single_exp}}, \code{\link{single_matern}}
}
\keyword{internal}
