% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zones.sum.R
\name{zones.sum}
\alias{zones.sum}
\title{Sum over zones}
\usage{
zones.sum(zones, y)
}
\arguments{
\item{zones}{A list of nearest neighbors in the format
produced by \code{\link{scan.zones}}.}

\item{y}{A numeric vector of values to be summed over.}
}
\value{
A numeric vector.
}
\description{
\code{zones.sum} computes the sum of \code{y} for the
indices in each element of the list contained in \code{zones}.
}
\examples{
# show nn.cumsum example for a circular scan setting
data(nydf)
coords <- with(nydf, cbind(longitude, latitude))
cases <- floor(nydf$cases)
zones <- scan.zones(coords, pop = nydf$pop, ubpop = 0.1)
# compute cumulative sums over all nn
szones <- zones.sum(zones, cases)
# compute cumulative sums over just the first set of nn
szones2 <- sapply(zones, function(x) sum(cases[x]))
# check equality
all.equal(szones, szones2)
}
