% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sig_noc.R
\name{sig_noc}
\alias{sig_noc}
\title{Return most significant, non-overlapping zones}
\usage{
sig_noc(tobs, zones, pvalue, alpha, order_by = "tobs")
}
\arguments{
\item{tobs}{The vector of observed test statistics for each zone}

\item{zones}{A list of zones}

\item{pvalue}{The p-value associated with each test statistic}

\item{alpha}{The significance level of the test.}

\item{order_by}{Either \code{'tobs'} or \code{'pvalue'},
indicating the argument by which to order \code{zones}.}
}
\value{
A list with the significant, ordered,
non-overlapping \code{tobs}, \code{zones}, \code{pvalue}.,
and \code{idx} (a vector with the relevant indices of
the original zones).
}
\description{
\code{sig_noc} return the significant, non-overlapping
zones order from most significant to least significant.
}
\examples{
tobs <- c(1, 3, 2)
zones <- list(1:2, 1:3, 2:3)
pvalue <- c(0.5, 0.01, 0.02)
sig_noc(tobs, zones, pvalue, alpha = 0.05)
}
