% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cepp.test.R
\name{cepp.test}
\alias{cepp.test}
\title{Cluster Evalation Permutation Procedure Test}
\usage{
cepp.test(
  coords,
  cases,
  pop,
  nstar,
  ex = sum(cases)/sum(pop) * pop,
  nsim = 499,
  alpha = 0.1,
  longlat = FALSE,
  simdist = "multinomial"
)
}
\arguments{
\item{coords}{An \eqn{n \times 2} matrix of centroid
coordinates for the regions in the form (x, y) or
(longitude, latitude) is using great circle distance.}

\item{cases}{The number of cases observed in each region.}

\item{pop}{The population size associated with each
region.}

\item{nstar}{The size of the at-risk population
in each window.}

\item{ex}{The expected number of cases for each region.
The default is calculated under the constant risk
hypothesis.}

\item{nsim}{The number of simulations from which to
compute the p-value.}

\item{alpha}{The significance level to determine whether
a cluster is signficant.  Default is 0.10.}

\item{longlat}{The default is \code{FALSE}, which
specifies that Euclidean distance should be used. If
\code{longlat} is \code{TRUE}, then the great circle
distance is used to calculate the intercentroid
distance.}

\item{simdist}{A character string indicating whether the
simulated data should come from a \code{"multinomial"}
or \code{"poisson"} distribution.  The default is
\code{"multinomial"}, which fixes the total number of
cases observed in each simulated data set.}
}
\value{
Returns a \code{smerc_cluster} object.
}
\description{
\code{cepp.test} implements the Cluster Evaluation
Permutation Procedure test of Turnbull et al. (1990)
for finding disease clusters.
}
\examples{
data(nydf)
data(nyw)
coords = with(nydf, cbind(x, y))
cases = nydf$cases
pop = nydf$pop
out = cepp.test(coords = coords, cases = cases, pop = pop,
                nstar = 1000, alpha = 0.99)
plot(out)
summary(out)

data(nypoly)
library(sp)
plot(nypoly, col = color.clusters(out))
}
\references{
Bruce W. Turnbull, Eric J. Iwano, William S. Burnett,
  Holly L. Howe, Larry C. Clark (1990).  Monitoring for Clusters of Disease:
  Application to Leukemia Incidence in Upstate New York,
  American Journal of Epidemiology, 132(supp1):136-143.
  <doi:10.1093/oxfordjournals.aje.a115775>
}
\seealso{
\code{\link{print.smerc_cluster}},
\code{\link{summary.smerc_cluster}},
\code{\link{plot.smerc_cluster}},
\code{\link{scan.test}}
}
\author{
Joshua French
}
