% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/uls.sim.R
\name{uls.sim}
\alias{uls.sim}
\title{Perform \code{uls.test} on simulated data}
\usage{
uls.sim(
  nsim = 1,
  ty,
  ex,
  w,
  pop,
  ubpop,
  type = "poisson",
  check.unique = FALSE,
  cl = NULL
)
}
\arguments{
\item{nsim}{A positive integer indicating the number of
simulations to perform.}

\item{ty}{The total number of cases in the study area.}

\item{ex}{The expected number of cases for each region.
The default is calculated under the constant risk
hypothesis.}

\item{w}{A binary spatial adjacency matrix for the
regions.}

\item{pop}{The population size associated with each
region.}

\item{ubpop}{The upperbound of the proportion of the
total population to consider for a cluster.}

\item{type}{The type of scan statistic to compute. The
default is \code{"poisson"}. The other choice
is \code{"binomial"}.}

\item{check.unique}{A logical value indicating whether a
check for unique values should be determined.  The
default is \code{FALSE}.  This is unlikely to make a
practical different for most real data sets.}

\item{cl}{
A cluster object created by \code{\link{makeCluster}},
or an integer to indicate number of child-processes
(integer values are ignored on Windows) for parallel evaluations
(see Details on performance).
}
}
\value{
A vector with the maximum test statistic for each
  simulated data set.
}
\description{
\code{uls.sim} efficiently performs
\code{\link{uls.test}} on a simulated data set.  The
function is meant to be used internally by the
\code{\link{uls.test}} function, but is informative for
better understanding the implementation of the test.
}
\examples{
data(nydf)
data(nyw)
coords = with(nydf, cbind(longitude, latitude))
cases = floor(nydf$cases)
pop = nydf$pop
ty = sum(cases)
ex = ty/sum(pop) * pop
tsim = uls.sim(1, ty, ex, nyw, pop = pop, ubpop = 0.5)
}
