% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distinct.R
\name{distinct}
\alias{distinct}
\title{Distinct elements of a list}
\usage{
distinct(x, N = max(unlist(x)))
}
\arguments{
\item{x}{A list of integers}

\item{N}{The largest integer value across all elements of \code{x}.}
}
\value{
A vector with the distinct indices.
}
\description{
\code{distinct} takes a list of integer vectors and 
returns the list indices that contain unique combinations
of elements.  This function is NOT robust against 
misuse, so please use properly.
}
\details{
Assume that \code{k} is the largest integer value in 
\code{x}.  A vector of the largest \code{k} prime numbers
is obtained (call this \code{pri}).  The algorithm takes 
the sum of the log of \code{pri[x[[i]]]} for each element
of \code{x}, and determines which sums are unique.  This
is why the elements of \code{x} must be integer vectors.
The prime aspect of the algorithm is critical, as it
ensures that a none of the values are multiples of the 
others, ensuring uniqueness.

Note: this algorithm has only been applied to data sets
where each element of \code{x[[i]]} appears only once,
though it should work for repeats also.
}
\examples{
x = list(1:3, 3:1, 1:4, 4:1, c(1, 2, 4, 6), c(6, 4, 1, 2))
x[distinct(x)]
}
\references{
Algorithm based on suggestion at \url{https://stackoverflow.com/a/29824978}.
}
\author{
Joshua French
}
