% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/smbinning.R
\name{smbinning.sql}
\alias{smbinning.sql}
\title{SQL Code}
\usage{
smbinning.sql(ivout)
}
\arguments{
\item{ivout}{An object generated by \code{smbinning}.}
}
\value{
A text with the SQL code for binning.
}
\description{
It outputs a SQL code to facilitate the generation of new binned characetristic
in a SQL environment.
}
\examples{
# Package loading and data exploration
library(smbinning) # Load package and its data
data(chileancredit) # Load smbinning sample dataset (Chilean Credit)
chileancredit.train=subset(chileancredit,FlagSample==1)
chileancredit.test=subset(chileancredit,FlagSample==0)
result=smbinning(df=chileancredit.train,y="FlagGB",x="TOB",p=0.05) # Run and save result

# Generate SQL code
smbinning.sql(result)
}

