% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/seasonalTools.R
\name{transfData}
\alias{transfData}
\title{Transfer raw dataset to the standard dataset (seasonal analysis toolbox)}
\usage{
transfData(data, dateFormat, roundValue = NULL, lengthUnit = "km")
}
\arguments{
\item{data}{The raw dataset.}

\item{dateFormat}{Charater string indicates the format of date variable.}

\item{roundValue}{Round GPS coordinate to \code{roundValue} with unit meter.
If NULL (default), no rounding will be processed.}

\item{lengthUnit}{Charater string indicates the length unit of GPS coordinate,
which can be "m" or "km"(default). Usually, we recommend not change the
default setup of this parameter. Otherwise, numerical computation problem
will happen.}
}
\value{
A \code{data.frame} containing the following components, which is
standard format of dataset in this package:

\itemize{
  \item date: tells us the date of collecting this sample point.
  \item cumTime: cumulative time line. The collection of this data starts
from time 0 in this time line. (Time unit is hours.)
  \item centerE: the centered east-west GPS coordinate with the center is
the starting point (when \code{cumTime[1]}).
  \item centerN: the centered north-south GPS coordinate with the center is
the starting point (when \code{cumTime[1]}).
}
}
\description{
Transfer the raw location dataset of animal to the standard dataset,
which is acceptable in this packages. The raw dataset contains at least
four components: 1. \code{t1}: data information. 2. \code{dt..hr.}: the
difference of time between two sample points. 3. \code{e1}: the GPS
coordinate of east-west. 4. \code{n1}: the GPS coordinate of north-south.
(These weird variable names are from the original GPS data. We will
change them in later version.)
}
\seealso{
\code{\link{as.Date}} has parameter \code{format}, which is the
same as the parameter \code{dateFormat} in this function.
}
\author{
Chaoran Hu
}
