% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graphs.R
\name{graph_attr_from_df}
\alias{graph_attr_from_df}
\title{Add Graph Attributes to a Graph from a Data Frame}
\usage{
graph_attr_from_df(g, df)
}
\arguments{
\item{g}{the graph (an igraph object) to which the graph attributes should
be added}

\item{df}{data frame, or an object that can be converted to a data
frame, where the first row contains a graph attribute in each column}
}
\value{
Graph \code{g} with the graph attributes in \code{df} added.
}
\description{
Add graph attributes to a graph from a data frame where each column
represents an attribute. Note that only the first row of the data frame
is used.
}
\examples{
g=igraph::graph_from_literal(1-2,2-3:4,3-4:5:6,5-1)
df=data.frame(name="Test Graph",descr="A graph")
graph_attr_from_df(g,df)
}
