% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CVerror.R
\name{CVerror}
\alias{CVerror}
\title{k-Fold Cross Validation Error Rate}
\usage{
CVerror(mod, k = nrow(stats::model.frame(mod)))
}
\arguments{
\item{mod}{A logistic regression, LDA, or QDA model}

\item{k}{Number of folds; by default LOOCV will be returned}
}
\value{
The k-fold CV error rate if k is entered, otherwise the LOOCV error rate.
}
\description{
Given a logistic regression model (via glm), or an LDA or QDA model, and a
number of folds k, the k-Fold CV error rate is calculated.
}
\examples{
mtcars$am=as.factor(mtcars$am)
gmod=glm(am~mpg,binomial,mtcars)
CVerror(gmod)
}
