%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% This file was automatically generated by Rdoc on 2001-04-20 20:18:16.
% Do NOT modify this file, instead modify the source (sma/R/Rmva.R).
% Rdoc is copyright (C) 2001, Henrik Bengtsson, henrikb@braju.com.
% Download the Rdoc compiler at http://www.braju.com/R/
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

\name{plot.smooth.line}

\alias{plot.smooth.line}

\title{Adding Lowess Lines to Current Plot}

\description{
 This function adds a \code{\link{lowess}} line to the current
 plot.  The  type of line can be specified as well as other
 parameters.} 

\usage{
plot.smooth.line(A, M, f=0.1, ...)
}

\arguments{
 \item{A}{a vector giving the x-coordinates of the points in the scatter
          plot. In the microarray context, this could be a vector of
          average log intensities.} 

 \item{M}{a vector giving the y-coordinates of the points in the scatter
          plot. In the microarray context, this could be a vector of
          log intensity ratios.} 

 \item{f}{the smoother span. This gives the proportion of points in the
          plot which influence the smoothness at each value. Larger
	  values give greater smoothness. } 

\item{\dots}{graphical parameters may also be supplied as arguments
to the function (see \code{\link{par}}).}        
}

\value{
 lines are added to the current plot.
}

\note{An M vs A plot must be constructed \bold{prior} to the execution of this function.}

\references{ Chambers, J. M., Cleveland, W. S., Kleiner, B. and Tukey,
P. A. (1983). Graphical Methods for Data Analysis. Wadsworth, Belmont,
California. }

\seealso{ \code{\link{plot.mva}}, \code{\link{stat.ma}},
\code{\link{lines}}, \code{\link{lowess}}, \code{\link{smooth}}. 
}

\examples{
data(MouseArray)
## mouse.setup <- init.grid()
## mouse.data <- init.data()

plot.mva(mouse.data, mouse.setup)
plot.smooth.line(mouse.lratio$A, mouse.lratio$M)
}

\keyword{microarray, lowess.}
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% End of File
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
