% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/the_plan.R
\name{the_plan}
\alias{the_plan}
\title{Check for possible actions for a \code{slurm_job} wrapper}
\usage{
the_plan(plan)
}
\arguments{
\item{plan}{A character scalar with either of the following values:
\code{"collect"}, \code{"wait"}, \code{"submit"}, or \code{"none"}.}
}
\value{
A list with three logical scalars.
}
\description{
Users can choose whether to submit the job or not, to wait for it, and whether
they want to collect the results right away after the job has finished. This
function will help developers to figure out what set of actions need to be
taken depending on the plan.
}
\details{
This is a helper function that returns a list with three logical values:
\code{wait}, \code{collect}, and \code{submit}. There are four possible cases:
\itemize{
\item \code{plan == "collect"}, then all three are \code{TRUE}.
\item \code{plan == "wait"}, then all but \code{collect} are \code{TRUE}.
\item \code{plan == "submit"} then only \code{submit} equals \code{TRUE}.
\item \code{plan == "none"} then all three are \code{FALSE}.
}

In general, bot \code{wait} and \code{submit} will be passed to \link{sbatch}.

When \code{collect == TRUE}, then it usually means that the function will be calling
\link{Slurm_collect} right after submitting the job via \link{sbatch}.
}
\examples{
the_plan("none")
# $collect
# [1] FALSE
#
# $wait
# [1] FALSE
#
# $submit
# [1] FALSE

the_plan("wait")
# $collect
# [1] FALSE
#
# $wait
# [1] TRUE
#
# $submit
# [1] TRUE
}
\seealso{
This is used in \link[=Slurm_lapply]{apply functions} and in \link{Slurm_EvalQ}.
}
