% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bash.R, R/slurm_job-class.R
\name{last_submitted_job}
\alias{last_submitted_job}
\alias{last_job}
\alias{slurm_job}
\alias{new_slurm_job}
\alias{print.slurm_job}
\alias{read_slurm_job}
\alias{write_slurm_job}
\title{Creating Slurm jobs}
\usage{
last_submitted_job()

last_job()

new_slurm_job(
  call,
  rscript,
  bashfile,
  robjects,
  njobs,
  opts_job,
  opts_r,
  hooks = NULL
)

\method{print}{slurm_job}(x, ...)

read_slurm_job(path)

write_slurm_job(x, path = NULL)
}
\arguments{
\item{call}{The original call}

\item{rscript, bashfile}{The R script and bash file path.}

\item{robjects}{A character vector of R objects that will be imported in the job.}

\item{njobs}{Integer. Number of jobs to start (array).}

\item{opts_job, opts_r}{List. In the case of \code{opts_job}, a list of parameters
passed to \link{sbatch}. \code{opts_r} is a list of parameters used within R. Both can
be retrieved by \link{opts_slurmR}\verb{$get_opts_job()} and \link{opts_slurmR}\verb{$get_opts_r()}
respectively.}

\item{hooks}{List of functions. To be called on the collected results after
it finalizes.}

\item{x}{An object of class \code{slurm_job}.}

\item{...}{Further arguments passed to the method.}

\item{path}{Character scalar. Path to either a directory with a \code{job.rds} file,
or directly to a \code{job.rds} file.}
}
\value{
An environment of class \code{slurm_job}. This has the following items:
\itemize{
\item \code{call} The original call (\link{Slurm_lapply}, \link{Slurm_Map}, etc.)
\item \code{rscript} The full path to the R script to be executed by bash file.
\item \code{bashfile} The full path to the bash file to be executed by \link{sbatch}.
\item \code{robjects} Ignored.
\item \code{njobs} The number of jobs to be submitted (job array).
\item \code{opts_job},\code{opts_r} Two lists of options as returned by \link{opts_slurmR}$get_opts_job()
and \link{opts_slurmR}$get_r_opts() at the moment of the creation of the \code{slurm_job}.
\item \code{hooks} A list of functions to be called on the collected objects
by \link{Slurm_collect}.
}

In the case of the function \code{write_slurm_job}, it returns the full
path to the file.
}
\description{
Utilities to deal with objects of class \code{slurm_job}. The function \code{new_slurm_job},
which is mostly intended to be for internal used, creates an object of class
\code{slurm_job}. The function \code{last_submitted_job} returns the last submitted
job in the current R session, and the functions \code{read/write_slurm_job} are
utility functions to read and write R jobs respectively.
}
\details{
The \code{las_submitted_job} function will return the latest \code{slurm_job}
object that was submitted via \link{sbatch} in the current session. The \code{last_job}
function is just an alias of the later. If no job has been submitted, then
the resulting value will be \code{NULL}.

In the case of the function \code{new_slurm_job}, besides of creating the
object of class \code{slurm_job}, the function calls \code{write_slurm_job} and stores
the job object in an \code{\link[=saveRDS]{rds}} class file. The name and location of
the saved rds file is generated using the function \code{snames("job")}.

The \code{read_slurm_job} can help the user recovering a previously saved
\code{slurm_job} object. If \code{path} is a directory, then the function will assume
that the file that is looking for lives within that directory and is named
\code{job.rds}. Otherwise, if a file, then it will read it directly. In any case,
it will check that the read object is an object of class \code{slurm_job}.

The \code{write_slurm_job} function simply takes a \code{slurm_job} object
and saves it in, if \code{path} is not specified, whatever the \code{job$options$chdir}
folder is under the name \code{job.rds}. If a path is specified, the it is directly
passed to \code{\link[=saveRDS]{saveRDS()}}.
}
\examples{
\dontrun{
# The last_job function can be handy when `plan = "collect"` in a called,
# for example
job <- Slurm_lapply(1:1000, function(i) runif(100), njobs = 2, plan = "collect")

# Post collection analysis
status(last_job())
}
}
