% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/slm-main.R
\name{slm}
\alias{slm}
\title{Fitting Stationary Linear Models}
\usage{
slm(myformula, data = NULL, model = TRUE, x = FALSE, y = FALSE,
  qr = TRUE, method_cov_st = "fitAR", cov_st = NULL, Cov_ST = NULL,
  model_selec = -1, model_max = 50, kernel_fonc = NULL,
  block_size = NULL, block_n = NULL, plot = FALSE)
}
\arguments{
\item{myformula}{an object of class "\code{\link[stats:formula]{formula}}" (or one that can be coerced to that class):
a symbolic description of the model to be fitted.}

\item{data}{an optional data frame, list or environment (or object coercible by \code{\link[base:as.data.frame]{as.data.frame}} to a data frame)
containing the variables in the model. If not found in \code{data}, the variables are taken from \code{environment(formula)},
typically the environment from which \code{slm} is called.}

\item{model, x, y, qr}{logicals. If \code{TRUE} the corresponding components of the fit (the model frame, the model matrix, the response, the QR decomposition) are returned.}

\item{method_cov_st}{the method chosen by the user to estimate the autocovariances of the error process. The user
has the choice between the methods "fitAR", "spectralproj", "efromovich", "kernel", or "select". By default, the
"fitAR" method is used.}

\item{cov_st}{the estimated autocovariances of the error process. The user can give his own vector.}

\item{Cov_ST}{an argument given by the user if he wants to use his own covariance matrix estimator.}

\item{model_selec}{the order of the method. If \code{model_selec = -1}, the method works automatically.}

\item{model_max}{maximal order of the method.}

\item{kernel_fonc}{to use if \code{method_cov_st = kernel}. Define the kernel to use in the method. The user can give his own kernel function.}

\item{block_size}{size of the bootstrap blocks if \code{method_cov_st = kernel}. \code{block_size} must be greater than \code{model_max}.}

\item{block_n}{blocks number to use for the bootstrap if \code{method_cov_st = kernel}.}

\item{plot}{logical. By default, \code{plot = FALSE}.}
}
\value{
\code{slm} returns an object of \code{\link[base:class]{class}} "\code{slm}". The function
\code{summary} is used to obtain and print a summary of the results. The generic accessor functions
\code{coefficients}, \code{effects}, \code{fitted.values} and \code{residuals} extract various
 useful features of the value returned by \code{slm}.
 An object of class "\code{slm}" is a list containing at least the following components:
 \item{method_cov_st }{ print the method chosen.}
 \item{cov_st }{ the estimated autocovariances of the error process.}
 \item{Cov_ST }{ if given by the user, the estimated covariance matrix of the error process.}
 \item{model_selec }{ the order of the method.}
 \item{norm_matrix }{ the normalization matrix of the design.}
 \item{design_qr }{ the matrix \eqn{(X^{t} X)^{-1}}.}
 \item{coefficients }{ a named vector of coefficients.}
 \item{residuals }{ the residuals, that is response minus fitted values.}
 \item{fitted.values }{ the fitted mean values.}
 \item{rank }{ the numeric rank of the fitted linear model.}
 \item{df.residual}{ the number of observations minus the number of variables.}
 \item{call }{ the matched call.}
 \item{terms }{ the \code{\link[stats:terms]{terms}} object used.}
 \item{xlevels }{ (only where relevant) a record of the levels of the factors used in fitting.}
 \item{y }{ if requested, the response used.}
 \item{x }{ if requested, the model matrix used.}
 \item{model }{ if requested (the default), the model frame used.}
}
\description{
\code{slm} is used to fit linear models when the error process is assumed to be strictly stationary.
}
\details{
The \code{slm} function is based on the architecture of the \code{lm} function.
 Models for \code{slm} are specified symbolically.
 A typical model has the form \code{response ~ terms} where \code{response} is the (numeric)
 response vector and \code{terms} is a series of terms which specifies a linear predictor for \code{response}.
 See the documentation of \code{\link[stats:lm]{lm}} for more details.
}
\examples{
data("shan")
slm(shan$PM_Xuhui ~ . , data = shan, method_cov_st = "fitAR", model_selec = -1)

data("co2")
y = as.vector(co2)
x = as.vector(time(co2)) - 1958
reg1 = slm(y ~ x + I(x^2) + I(x^3) + sin(2*pi*x) + cos(2*pi*x) + sin(4*pi*x) +
 cos(4*pi*x) + sin(6*pi*x) + cos(6*pi*x) + sin(8*pi*x) + cos(8*pi*x),
 method_cov_st = "fitAR", model_selec = -1, plot = TRUE)

reg2 = slm(y ~ x + I(x^2) + I(x^3) + sin(2*pi*x) + cos(2*pi*x) + sin(4*pi*x) +
 cos(4*pi*x) + sin(6*pi*x) + cos(6*pi*x) + sin(8*pi*x) + cos(8*pi*x),
 method_cov_st = "kernel", model_selec = -1, model_max = 50, kernel_fonc = triangle,
 block_size = 100, block_n = 100)
}
\references{
E. Caron, J. Dedecker and B. Michel (2019). Linear regression with stationary errors: the R package slm. \emph{arXiv preprint arXiv:1906.06583}.
 \url{https://arxiv.org/abs/1906.06583}.
}
\seealso{
\code{\link[slm:summary.slm]{summary}} for summaries.

The generic functions \code{\link[stats:coef]{coef}}, \code{\link[stats:effects]{effects}},
\code{\link[stats:residuals]{residuals}}, \code{\link[stats:fitted]{fitted}}, \code{\link[stats:vcov]{vcov}}.

\code{\link[slm:predict.slm]{predict}} for prediction, including confidence intervals for \eqn{x' beta}, where \eqn{x'} is a new observation of the design.

\code{\link[slm:confint.slm]{confint}} for confidence intervals of \emph{parameters}.
}
