% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aoi_processing.R
\name{validate_poi}
\alias{validate_poi}
\title{bbox from center point}
\usage{
validate_poi(poi = NULL, product = NULL, buff = 0)
}
\arguments{
\item{poi}{Numeric; length-2 vector of x, y coordinates or `sf` style point.}

\item{product}{Character, one of the options from column 'Short_Name' in
\code{\link[slga:slga_product_info]{slga_product_info}}.}

\item{buff}{Integer, cell buffer around point. Defaults to 0 (single cell).}
}
\value{
sf style bbox or list of same, aligned to requested product, centered
  on `point` and extending `buff` cells away from centre.
}
\description{
Get a bounding box from an x,y point and desired buffer distance
}
\note{
This is for buffered data requests around a point.
}
\examples{
{
library(slga)
poi <- c(152, -27)

# size 0 = extent of single cell
slga:::validate_poi(poi = poi, product = 'SLPPC', buff = 0)

# size 3 = 7x7 cells (centre cell and 3 in each direction)
slga:::validate_poi(poi = poi, product = 'SLPPC', buff = 3)
}

}
\keyword{internal}
