% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tex_slackr.R
\name{tex_slackr}
\alias{tex_slackr}
\title{Post a tex output to a Slack channel}
\usage{
tex_slackr(
  obj,
  channels = Sys.getenv("SLACK_CHANNEL"),
  bot_user_oauth_token = Sys.getenv("SLACK_BOT_USER_OAUTH_TOKEN"),
  ext = "png",
  path = NULL,
  ...
)
}
\arguments{
\item{obj}{character object containing tex to compile}

\item{channels}{list of channels to post image to}

\item{bot_user_oauth_token}{the Slack full bot user OAuth token (chr)}

\item{ext}{character, type of format to return, can be tex, pdf, or any image device, Default: 'png'}

\item{path}{character, path to save tex_preview outputs, if NULL then tempdir is used, Default: NULL}

\item{...}{other arguments passed to \code{\link[texPreview:tex_preview]{texPreview::tex_preview()}}, see Details}
}
\value{
\code{httr} response object (invisibly)
}
\description{
Unlike the \code{\link[=dev_slackr]{dev_slackr()}} function, this one takes a \code{tex} object,
eliminating the need write to pdf and convert to png to pass to slack.
}
\details{
Please make sure \code{texPreview} package is installed before running this function.
For TeX setup refer to the
\href{https://github.com/mrkaye97/slackr#latex-for-tex_slackr}{Setup notes on \code{LaTeX}}.
}
\note{
You need to setup a full API token (i.e. not a webhook & not OAuth) for this to work
Also, you can pass in \code{add_user=TRUE} as part of the \code{...}
parameters and the Slack API will post the message as your logged-in user
account (this will override anything set in \code{username})
}
\examples{
\dontrun{
slackr_setup()
obj=xtable::xtable(mtcars)
tex_slackr(obj,print.xtable.opts=list(scalebox=getOption("xtable.scalebox", 0.8)))

tex_slackr(obj,ext = 'pdf',print.xtable.opts=list(scalebox=getOption("xtable.scalebox", 0.8)))

tex_slackr(obj,ext = 'tex',print.xtable.opts=list(scalebox=getOption("xtable.scalebox", 0.8)))

tex_slackr(obj,path='testdir',print.xtable.opts=list(scalebox=getOption("xtable.scalebox", 0.8)))
}
}
\seealso{
\code{\link[texPreview:tex_preview]{texPreview::tex_preview()}} \code{\link[xtable:print.xtable]{xtable::print.xtable()}}
}
\author{
Jonathan Sidi (aut)
}
