\name{skewtools-package}
\alias{skewtools-package}
\alias{skewtools}
\docType{package}
\title{
Tools for analyze Skew-Elliptical distributions and related models
}
\description{
This package includes functions related to the following
topics: 1. Information Theory: Entropy and Mutual Information
Index for Multivariate Skew-t and Skew-Normal distributions. 
2. Parameter estimation of the Von Bertalanffy, Gompertz, 
Logistic and Richards growth models using the robust ECME 
method and Heteroscedastic Nonlinear Regression Growth 
with scale mixture of Skew-Normal distributions (Normal, 
T-Student,Skew-Normal and Skew-t). This package also 
includes Bootstrap and Jackknife methods to estimate 
the Variance-Covariance matrix and the Local Influence

}
\details{
\tabular{ll}{
Package: \tab skewtools\cr
Type: \tab Package\cr
Version: \tab 0.1.0\cr
Date: \tab 2012-04-02\cr
License: \tab GPL >= 2\cr
LazyLoad: \tab yes\cr
}

The HNL.skew funcion is based on the ECME method of the scripts written by Lachos et al. (2012) 
(open access: \url{http://www.ime.unicamp.br/~hlachos/codeSMSN-HNLM.rar}). 
}
\author{
Javier E. Contreras-Reyes, Instituto de Fomento Pesquero, Valparaiso, Chile

Maintainer: Javier E. Contreras-Reyes <javier.contreras@ifop.cl>
}
\references{
Akaike, H. (1974). A new look at the statistical model identification. \emph{IEEE T. Automat. Contr.}, 19, 6, 716-723.

Arellano-Valle, R. B., Contreras-Reyes, J. E., Genton, M. G. (2012). Shannon Entropy and Mutual Information for Multivariate
Skew-Elliptical Distributions. \emph{Scand. J. Stat.}, doi: 10.1111/j.1467-9469.2011.00774.x.

Burnham, K. P., Anderson, D.R. (2002). \emph{Model Selection and Multimodel Inference: A Practical Information-Theoretic Approach}, 2nd ed. Springer-Verlag.

Basso, R. M., Lachos, V. H., Barbosa, C. R., Ghosh, P., (2010). Robust mixture modeling based on scale mixtures of skew-normal distributions. \emph{Comput. Stat. Data An.}, 54, 12, 2926-2941.

Contreras-Reyes, J.E., Arellano-Valle, R.B. (2012). Kullback-Leibler divergence measure for Multivariate Skew-Normal Distributions. Pre-print.

Cook, R. D., (1986). Assessment of local influence (with discussion). \emph{ J. R. Stat. Soc. Ser. B}, 48, 2, 133-169.Efron, B., Tibshirani, R., J. (1993). \emph{ An Introduction to the Bootstrap}. Chapman & Hall/CRC, Monographs on Statistics & Applied Probability.

Gompertz, B. (1825). On the Nature of the Function Expressive of the Law of Human Mortality, and on a New Mode of Determining the Value of Life Contingencies. 
\emph{Philosophical Transactions of the Royal Society of London}, 115, 513-585.

Hurvich, C. M., and Tsai, C.-L. (1989). Regression Growth and time series model selection in small samples. \emph{Biometrika}, 76, 297-307.

Javier, W. R., Gupta, A. K. (2009). Mutual information for certain multivariate distributions. \emph{Far East J. Theor. Stat.}, 29, 39-51.

Lange, K. L., Sinsheimer, J. S., (1993). Normal/independent distributions and their applications in robust Regression Growth. \emph{ J. Comput. Graph. Stat}, 2, 2, 175-198.

Lange, D., Tilmann, F., Barrientos, S., Contreras-Reyes, E., Methe, P., Moreno, M., Heit, B., Bernard, P., Vilotte, J., Beck, S. (2012). Aftershock seismicity of the 27 February 2010 Mw 8.8
Maule earthquake rupture zone. \emph{Earth and Planetary Science Letters}, doi:10.1016/j.epsl.2011.11.034.

Lachos, V. H., Ghosh, P., Arellano-Valle R. B. (2010). Likelihood Based Inference for Skew-Normal/Independent Linear Mixed Model. \emph{ Stat. Sinica}, 20, 303-322.

Lachos, V. H., Bandyopadhyay, D., Garay,  A. M., (2011). Heteroscedastic nonlinear Regression Growth models based on scale mixtures of skew-normal distributions. \emph{Stat. Probabil. Lett.}, 81, 8, 1208-1217.

Lachos, V. H., Garay, A. M., Ortega, E. M., Vilca, L. F. (2012). Estimation and diagnostics for heteroscedastic nonlinear Regression Growth models based on scale mixtures of skew-normal distributions. \emph{J. Stat. Plann. Inf.}, to appear.

Liu, C., Rubin, D. B., (1994). The ECME algorithm: A simple extension of EM and ECM with faster monotone convergence. \emph{Biometrika}, 81, 4, 267-278.

Poon, W., Poon, Y. S., (1999). Conformal normal curvature and assessment of local influence. \emph{ J. R. Stat. Soc. Ser. B}, 61, 1, 51-61.

Schnute, J. T., Richards, L. J. (1990). A Unified Approach to the Analysis of Fish Growth, Maturity, and Survivorship Data. \emph{Can. J. Fish. Aquat. Sci.}, 47, 24-37. 

Schwarz, G. E. (1978). Estimating the dimension of a model. \emph{Annals of Statistics}, 6, 2, 461-464.

Silva, C., Quiroz, A. (2003). Optimization of the atmospheric pollution monitoring network at Santiago de Chile. \emph{Atmospheric Environment}, 37, 2337-2345.

Verhulst, P. -F. (1838). Notice sur la loi que la population poursuit dans son accroissement. \emph{Correspondance mathematique et physique}, 10, 113-121.

von Bertalanffy, L. (1938).Aquantitative theory of organic growth (Inquiries on growth laws. II). Human Biology 10, 181-213.

Wasserman, L. (2006). \emph{All of Nonparametric Statistics}. Springer-Verlag, New York Inc, USA.

Wu, C., F., J. (1986). Jackknife, Bootstrap and Other Resampling Methods in Regression Growth Analysis. \emph{ The Annals of Statistics}, 14, 4, 1261-1295.
}

\keyword{skewtools}
\keyword{package}
