% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cook_weisberg.R
\name{cook_weisberg}
\alias{cook_weisberg}
\title{Cook-Weisberg Score Test for Heteroskedasticity in a Linear Regression Model}
\usage{
cook_weisberg(
  mainlm,
  auxdesign = NA,
  hetfun = c("mult", "add", "logmult"),
  statonly = FALSE
)
}
\arguments{
\item{mainlm}{Either an object of \code{\link[base]{class}} \code{"lm"}
(e.g., generated by \code{\link[stats]{lm}}), or
a list of two objects: a response vector and a design matrix. The objects
are assumed to be in that order, unless they are given the names
\code{"X"}  and \code{"y"} to distinguish them. The design matrix passed
in a list must begin with a column of ones if an intercept is to be
included in the linear model. The design matrix passed in a list should
not contain factors, as all columns are treated 'as is'. For tests that
use ordinary least squares residuals, one can also pass a vector of
residuals in the list, which should either be the third object or be
named \code{"e"}.}

\item{auxdesign}{A \code{\link[base]{data.frame}} or
\code{\link[base]{matrix}} representing an auxiliary design matrix of
containing exogenous variables that (under alternative hypothesis) are
related to error variance, or a character "fitted.values" indicating
that the fitted \eqn{\hat{y}_i} values from OLS should be used.
If set to \code{NA} (the default), the
design matrix of the original regression model is used. An intercept
is included in the auxiliary regression even if the first column of
\code{auxdesign} is not a vector of ones.}

\item{hetfun}{A character describing the form of \eqn{w(\cdot)}, the error
variance function under the heteroskedastic alternative. Possible values
are \code{"mult"} (the default), corresponding to
\eqn{w(Z_i,\lambda)=\exp\left\{\sum_{j=1}^{q}\lambda_j Z_{ij}\right\}},
\code{"add"}, corresponding to
\eqn{w(Z_i,\lambda)=\left(1+\sum_{j=1}^{q} \lambda_j Z_{ij}\right)^2}, and
\code{"logmult"}, corresponding to
\eqn{w(Z_i,\lambda)=\exp\left\{\sum_{j=1}^{q}\lambda_j \log Z_{ij}\right\}}.
The multiplicative and log-multiplicative cases are considered in
\insertCite{Cook83;textual}{skedastic}; the additive case is discussed,
\emph{inter alia}, by \insertCite{Griffiths86;textual}{skedastic}.
Results for the additive and multiplicative models are identical for this
test. Partial matching is used.}

\item{statonly}{A logical. If \code{TRUE}, only the test statistic value
is returned, instead of an object of \code{\link[base]{class}}
\code{"htest"}. Defaults to \code{FALSE}.}
}
\value{
An object of \code{\link[base]{class}} \code{"htest"}. If object is
   not assigned, its attributes are displayed in the console as a
   \code{\link[tibble]{tibble}} using \code{\link[broom]{tidy}}.
}
\description{
This function implements the score test of
   \insertCite{Cook83;textual}{skedastic} for testing for heteroskedasticity
   in a linear regression model.
}
\details{
The Cook-Weisberg Score Test entails fitting an auxiliary regression model
in which the response variable is the vector of standardised squared
residuals \eqn{e_i^2/\hat{\sigma}^2} from the original OLS
model and the design matrix is some function of \eqn{Z}, an
\eqn{n \times q} matrix consisting of \eqn{q} exogenous variables, appended
to a column of ones.
The test statistic is half the residual sum of squares from this auxiliary
regression. Under the null hypothesis of homoskedasticity, the distribution
of the test statistic is asymptotically chi-squared with \eqn{q} degrees of
freedom. The test is right-tailed.
}
\examples{
mtcars_lm <- lm(mpg ~ wt + qsec + am, data = mtcars)
cook_weisberg(mtcars_lm)
cook_weisberg(mtcars_lm, auxdesign = "fitted.values", hetfun = "logmult")

}
\references{
{\insertAllCited{}}
}
\seealso{
\code{\link[car:ncvTest]{car::ncvTest}}, which implements the same
test. Calling \code{car::ncvTest} with \code{var.formula} argument omitted
is equivalent to calling \code{skedastic::cook_weisberg} with
\code{auxdesign = "fitted.values", hetfun = "additive"}. Calling
\code{car::ncvTest} with \code{var.formula = ~ X} (where \code{X} is the
design matrix of the linear model with the intercept column omitted) is
equivalent to calling \code{skedastic::cook_weisberg} with default
\code{auxdesign} and \code{hetfun} values. The
\code{hetfun = "multiplicative"} option has no equivalent in
\code{car::ncvTest}.
}
