% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cv.R
\name{cv}
\alias{cv}
\title{Coefficient of Variation}
\usage{
cv(x, ...)
}
\arguments{
\item{x}{(Numeric) vector or a fitted linear model of class
\code{\link{lm}}, \code{\link[lme4]{merMod}} (\pkg{lme4}) or
\code{\link[nlme]{lme}} (\pkg{nlme}).}

\item{...}{More fitted model objects, to compute multiple coefficients of
variation at once.}
}
\value{
The coefficient of variation of \code{x}.
}
\description{
Compute coefficient of variation for single variables
               (standard deviation divided by mean) or for fitted
               linear (mixed effects) models (root mean squared error
               (RMSE) divided by mean of dependent variable).
}
\details{
The advantage of the cv is that it is unitless. This allows
           coefficient of variation to be compared to each other in ways
           that other measures, like standard deviations or root mean
           squared residuals, cannot be.
           \cr \cr
           \dQuote{It is interesting to note the differences between a model's CV
           and R-squared values. Both are unitless measures that are indicative
           of model fit, but they define model fit in two different ways: CV
           evaluates the relative closeness of the predictions to the actual
           values while R-squared evaluates how much of the variability in the
           actual values is explained by the model.}
           \cite{(\href{http://www.ats.ucla.edu/stat/mult_pkg/faq/general/coefficient_of_variation.htm}{source: UCLA-FAQ})}
}
\examples{
data(efc)
cv(efc$e17age)

fit <- lm(neg_c_7 ~ e42dep, data = efc)
cv(fit)

library(lme4)
fit <- lmer(Reaction ~ Days + (Days | Subject), sleepstudy)
cv(fit)

library(nlme)
fit <- lme(Reaction ~ Days, random = ~ Days | Subject, data = sleepstudy)
cv(fit)

}
\references{
Everitt, Brian (1998). The Cambridge Dictionary of Statistics. Cambridge, UK New York: Cambridge University Press
}
\seealso{
\code{\link{rmse}}
}
