% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rec_pattern.R
\name{rec_pattern}
\alias{rec_pattern}
\title{Create recode pattern for 'rec' function}
\usage{
rec_pattern(from, to, width = 5, other = NULL)
}
\arguments{
\item{from}{Minimum value that should be recoded.}

\item{to}{Maximum value that should be recoded.}

\item{width}{Numeric, indicating the range of each group.}

\item{other}{String token, indicating how to deal with all other values
that have not been captured by the recode pattern. See 'Details'
on the \code{else}-token in \code{\link{rec}}.}
}
\value{
A list with two values:
          \describe{
           \item{\code{pattern}}{string pattern that can be used as \code{recodes} argument for the \code{\link{rec}}-function.}
           \item{\code{labels}}{the associated values labels that can be used with \code{\link{set_labels}}.}
          }
}
\description{
Convenient function to create a recode pattern for the
               \code{\link{rec}} function, which recodes (numeric)
               vectors into smaller groups.
}
\examples{
rp <- rec_pattern(1, 100)
rp

# sample data, inspect age of carers
data(efc)
table(efc$c160age, exclude = NULL)
table(rec(efc$c160age, recodes = rp$pattern), exclude = NULL)

# recode carers age into groups of width 5
x <- rec(
  efc$c160age,
  recodes = rp$pattern,
  val.labels = rp$labels
)
# watch result
frq(x)

}
\seealso{
\code{\link{group_var}} for recoding variables into smaller groups, and
          \code{\link{group_labels}} to create the asssociated value labels.
}
