% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/sjImportSPSS.R
\name{to_value}
\alias{to_value}
\title{Converts factors to numeric variables}
\usage{
to_value(x, startAt = 1, keep.labels = TRUE)
}
\arguments{
\item{x}{A (factor) variable.}

\item{startAt}{the starting index, i.e. the lowest numeric value of the variable's
value range.}

\item{keep.labels}{logical, if \code{TRUE}, former factor levels will be attached as
value labels. See \code{\link{set_val_labels}} for more details.}
}
\value{
A numeric variable with values ranging from \code{startAt} to
          \code{startAt} + length of factor levels.
}
\description{
This function converts (replaces) factor values with the
related factor level index number, thus the factor is converted to
a numeric variable.
}
\examples{
data(efc)
test <- to_label(efc$e42dep)
table(test)

table(to_value(test))
hist(to_value(test, 0))

# set lowest value of new variable
# to "5".
table(to_value(test, 5))
}
\seealso{
\code{\link{to_label}} to convert a value into a factor with labelled
           factor levels and \code{\link{to_fac}} to convert a numeric variable
           into a factor (and retain labels)
}

