% Generated by roxygen2 (4.0.2): do not edit by hand
\name{sjp.lm1}
\alias{sjp.lm1}
\title{Plot regression line of fitted lm}
\usage{
sjp.lm1(fit, data, title = NULL, breakTitleAt = 50, axisLabel.x = NULL,
  axisLabel.y = NULL, breakLabelsAt = 20, lineColor = "blue",
  showCI = TRUE, ciLevel = 0.95, pointAlpha = 0.2, pointColor = "black",
  showScatterPlot = TRUE, showLoess = FALSE, loessLineColor = "red",
  showLoessCI = FALSE, loessCiLevel = 0.95, showModelSummary = TRUE,
  printPlot = TRUE)
}
\arguments{
\item{fit}{The model of the linear regression (lm-Object).}

\item{data}{The data/dataset/dataframe used to fit the model}

\item{title}{Diagram's title as string.
Example: \code{title=c("my title")}}

\item{breakTitleAt}{Wordwrap for diagram title. Determines how many chars of the title are displayed in
one line and when a line break is inserted into the title}

\item{axisLabel.x}{Labels of the predictor (independent variable) that is used for labelling the
axis. Passed as string.
Example: \code{axisLabel.x=c("My Predictor Var")}.
Note: If you use the \code{\link{sji.SPSS}} function and the \code{\link{sji.getVariableLabels}} function, you receive a
character vector with variable label strings. You can use it like so:
\code{axisLabel.x=sji.getVariableLabels(efc)['quol_5']}}

\item{axisLabel.y}{Labels of the response (dependent variable) that is used for labelling the
axis. Passed as string.
Example: \code{axisLabel.y=c("My Depdendent Var")}.
Note: If you use the \code{\link{sji.SPSS}} function and the \code{\link{sji.getVariableLabels}} function, you receive a
character vector with variable label strings. You can use it like so:
\code{axisLabel.y=sji.getVariableLabels(efc)['neg_c_7']}}

\item{breakLabelsAt}{Wordwrap for axis labels. Determines how many chars of the category labels are displayed in
one line and when a line break is inserted}

\item{lineColor}{The color of the regression line. Default is \code{"blue"}.}

\item{showCI}{If \code{TRUE} (default), a confidence region for the regression line
will be plotted. Use \code{ciLevel} to specifiy the confidence level.}

\item{ciLevel}{The confidence level of the confidence region. Only applies when
\code{showCI} is \code{TRUE}. Default is 0.95.}

\item{pointAlpha}{The alpha values of the scatter plot's point-geoms.
Default is 0.2.}

\item{pointColor}{The color of the scatter plot's point-geoms. Only applies when \code{showScatterPlot}
is \code{TRUE}. Default is \code{"black"}.}

\item{showScatterPlot}{If \code{TRUE} (default), a scatter plot of response and predictor values
for each predictor of the fitted model \code{fit} is plotted.}

\item{showLoess}{If \code{TRUE}, an additional loess-smoothed line is plotted.}

\item{loessLineColor}{The color of the loess-smoothed line. Default is \code{"red"}. Only applies, if
\code{showLoess} is \code{TRUE}.}

\item{showLoessCI}{If \code{TRUE}, a confidence region for the loess-smoothed line
will be plotted. Default is \code{FALSE}. Use \code{loessCiLevel} to specifiy the confidence level.
Only applies, if \code{showLoess} is \code{TRUE}.}

\item{loessCiLevel}{The confidence level of the loess-line's confidence region.
Only applies, if \code{showLoessCI} is \code{TRUE}. Default is 0.95.}

\item{showModelSummary}{If \code{TRUE} (default), a summary of the regression model with
Intercept, R-square, F-Test and AIC-value is printed to the lower right corner
of the diagram.}

\item{printPlot}{If \code{TRUE} (default), plots the results as graph. Use \code{FALSE} if you don't
want to plot any graphs. In either case, the ggplot-object will be returned as value.}
}
\value{
(Insisibily) returns the ggplot-object with the complete plot (\code{plot}) as well as the data frame that
          was used for setting up the ggplot-object (\code{df}).
}
\description{
Plot a regression line with confidence interval for a fitted model with only
               one predictor (i.e. \code{lm(y~x)}).
               This function may plot two lines: The resulting linear regression line
               including confidence interval (in blue) by default, and a loess-smoothed line without
               confidence interval (in red) if parameter \code{showLoess} is \code{TRUE}.
               The better the linear relationship of predictor and response is, the more both lines should overlap
               (i.e. the red loess-smoothed line is almost linear). \cr \cr
               Furthermore, a scatter plot of response and predictor values
               is plotted.
}
\examples{
# load sample data
data(efc)
# fit model
fit <- lm(neg_c_7 ~ quol_5, data=efc, na.action=na.omit)
# plot regression line
sjp.lm1(fit, efc)
# plot regression line with label strings
sjp.lm1(fit,
        efc,
        axisLabel.x=sji.getVariableLabels(efc)['quol_5'],
        axisLabel.y=sji.getVariableLabels(efc)['neg_c_7'],
        showLoess=TRUE)
}
\seealso{
\itemize{
             \item \href{http://www.strengejacke.de/sjPlot/sjp.lm}{sjPlot manual: sjp.lm}
             \item \code{\link{sjp.lm}}
             \item \code{\link{sjp.reglin}}
             \item \code{\link{sjp.scatter}}
            }
}

