% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sits_view.R
\name{sits_view}
\alias{sits_view}
\alias{sits_view.sits}
\alias{sits_view.data.frame}
\alias{sits_view.som_map}
\alias{sits_view.raster_cube}
\alias{sits_view.uncertainty_cube}
\alias{sits_view.class_cube}
\alias{sits_view.probs_cube}
\alias{sits_view.default}
\title{View data cubes and samples in leaflet}
\usage{
sits_view(x, ...)

\method{sits_view}{sits}(x, ..., legend = NULL, palette = "Harmonic")

\method{sits_view}{data.frame}(x, ..., legend = NULL, palette = "Harmonic")

\method{sits_view}{som_map}(x, ..., id_neurons, legend = NULL, palette = "Harmonic")

\method{sits_view}{raster_cube}(
  x,
  ...,
  band = NULL,
  red = NULL,
  green = NULL,
  blue = NULL,
  tiles = x$tile,
  dates = NULL,
  class_cube = NULL,
  legend = NULL,
  view_max_mb = NULL,
  palette = "RdYlGn"
)

\method{sits_view}{uncertainty_cube}(
  x,
  ...,
  tiles = x$tile,
  class_cube = NULL,
  legend = NULL,
  view_max_mb = NULL,
  palette = "Blues"
)

\method{sits_view}{class_cube}(
  x,
  ...,
  tiles = NULL,
  legend = NULL,
  palette = "default",
  view_max_mb = NULL
)

\method{sits_view}{probs_cube}(
  x,
  ...,
  tiles = x$tile,
  class_cube = NULL,
  legend = NULL,
  view_max_mb = NULL,
  palette = "YlGnBu"
)

\method{sits_view}{default}(x, ...)
}
\arguments{
\item{x}{Object of class "sits", "data.frame", "som_map",
"raster_cube" or "classified image".}

\item{...}{Further specifications for \link{sits_view}.}

\item{legend}{Named vector that associates labels to colors.}

\item{palette}{Palette provided in the configuration file.}

\item{id_neurons}{Neurons from the SOM map to be shown.}

\item{band}{For plotting grey images.}

\item{red}{Band for red color.}

\item{green}{Band for green color.}

\item{blue}{Band for blue color.}

\item{tiles}{Tiles to be plotted (in case of a multi-tile cube).}

\item{dates}{Dates to be plotted.}

\item{class_cube}{Classified cube to be overlayed on top on image.}

\item{view_max_mb}{Maximum size of leaflet to be visualized}
}
\value{
A leaflet object containing either samples or
                      data cubes embedded in a global map that can
                      be visualized directly in an RStudio viewer.
}
\description{
Uses leaflet to visualize time series, raster cube and
classified images
}
\note{
Please refer to the sits documentation available in
<https://e-sensing.github.io/sitsbook/> for detailed examples.
}
\examples{
if (sits_run_examples()) {
    sits_view(cerrado_2classes)

    data_dir <- system.file("extdata/raster/mod13q1", package = "sits")

    modis_cube <- sits_cube(
        source = "BDC",
        collection = "MOD13Q1-6",
        data_dir = data_dir
    )
    # view the data cube
    sits_view(modis_cube,
        band = "NDVI"
    )
    # train a model
    rf_model <- sits_train(samples_modis_ndvi, sits_rfor())

    modis_probs <- sits_classify(
        data = modis_cube,
        ml_model = rf_model,
        output_dir = tempdir()
    )
    modis_label <- sits_label_classification(
        modis_probs,
        output_dir = tempdir()
    )

    sits_view(modis_label)

    sits_view(modis_cube,
        band = "NDVI",
        class_cube = modis_label,
        dates = sits_timeline(modis_cube)[[1]]
    )
    modis_uncert <- sits_uncertainty(
        cube = modis_probs,
        output_dir = tempdir()
    )
    sits_view(modis_uncert)
}
}
\author{
Gilberto Camara, \email{gilberto.camara@inpe.br}
}
