% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sits_mixture_model.R
\name{.mesma_raster_blocks}
\alias{.mesma_raster_blocks}
\title{Define a reasonable block size to process an image subset}
\usage{
.mesma_raster_blocks(nbands, sub_image, memsize, multicores)
}
\arguments{
\item{nbands}{Number of bands to open.}

\item{sub_image}{Bounding box of the ROI.}

\item{memsize}{Memory available for classification (in GB).}

\item{multicores}{Number of cores to process the time series.}
}
\value{
List with three attributes: n (number of blocks),
                   rows (list of rows to begin),
                   nrows (number of rows to read at each iteration).
}
\description{
Defines the size of the block of an image to be read.
For example, a Raster Brick with 500 rows and 500 columns
and 400 time instances will have a total pixel size
of 800 Mb if pixels are 64-bit.
}
\author{
Gilberto Camara, \email{gilberto.camara@inpe.br}
}
\keyword{internal}
