% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sinx.R
\name{read.sinxs}
\alias{read.sinxs}
\title{Read sayings from spread sheets.}
\usage{
read.sinxs(file = NULL, sep = ",", lib = "sinxs")
}
\arguments{
\item{file}{a character string giving a sinx sayings database in csv format (in UTF-8 encoding). By default all csv files in the data directory of the sinx package are used.}

\item{sep}{seperator of the columns. See '?read.table()'.}

\item{lib}{library name of the sayings.}
}
\value{
a data frame of sayings, each row contains:
- quote:	the quote, main part of the sayings,
- author: the author of the quote,
- context: the context in which it was quoted (if available, otherwise NA),
- source	: where it was quoted (if available, otherwise NA),
- date:	when it was quoted (if available, otherwise NA).
}
\description{
Read sayings from spread sheets.
}
\examples{
libs <- read.sinxs()
libs_ts <- read.sinxs(system.file("sinxs/tangshi.csv", package = "sinx"))
}
