% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim_trait_mvn.R
\name{sim_trait_mvn}
\alias{sim_trait_mvn}
\title{Simulate traits from a kinship matrix under the infinitesimal model}
\usage{
sim_trait_mvn(
  rep,
  kinship,
  herit,
  mu = 0,
  sigma_sq = 1,
  labs = NULL,
  labs_sigma_sq = NULL,
  tol = 1e-06
)
}
\arguments{
\item{rep}{The number of replicate traits to simulate.
Simulating all you need at once is more efficient than simulating each separately (the kinship matrix is eigendecomposed once per run, shared across replicates).}

\item{kinship}{The \code{n}-by-\code{n} kinship matrix of the individuals to simulate from.}

\item{herit}{The desired heritability (proportion of trait variance due to genetics).}

\item{mu}{The desired parametric mean value of the trait (scalar, default 0).}

\item{sigma_sq}{The desired parametric variance factor of the trait (scalar, default 1).
Corresponds to the variance of an outbred individual.}

\item{labs}{Optional labels assigning individuals to groups, to simulate group effects.
If vector, length must be number of individuals.
If matrix, individuals must be along rows, and levels along columns (for multiple levels of group effects).
The levels are not required to be nested (as the name may falsely imply).
Values can be numeric or strings, simply assigning the same values to individuals in the same group.
If this is non-\code{NULL}, then \code{labs_sigma_sq} must also be given!}

\item{labs_sigma_sq}{Optional vector of group effect variances, one value for each level given in \code{labs} (a scalar if \code{labs} is a vector, otherwise its length should be the number of columns of \code{labs}).
Ignored unless \code{labs} is also given.
As these are variance components, each value must be non-negative and \code{sum(labs_sigma_sq) + herit <= 1} is required!}

\item{tol}{Tolerance factor for an internal test of positive semi-definiteness of the trait covariance matrix.
Procedure fails if any eigenvalues are smaller than \code{-tol} times the absolute value of the largest eigenvalue.
Increase this value only if you are getting errors but you're sure your covariance matrix (the output of \code{\link[=cov_trait]{cov_trait()}}) is positive semi-definite.}
}
\value{
A \code{rep}-by-\code{n} matrix containing the simulated traits along the rows, individuals along the columns.
}
\description{
Simulate matrix of trait replicates given a kinship matrix and model parameters (the desired heritability, total variance scale, and mean).
Although these traits have the covariance structure of genetic traits, and have heritabilities that can be estimated, they do not have causal loci (an association test against any locus should fail).
Below \code{n} is the number of individuals.
}
\examples{
# create a dummy kinship matrix
# make sure it is positive definite!
kinship <- matrix(
    data = c(
        0.6, 0.1, 0.0,
        0.1, 0.5, 0.0,
        0.0, 0.0, 0.5
    ),
    nrow = 3
)
# draw simulated traits (matrix)
traits <- sim_trait_mvn( rep = 10, kinship = kinship, herit = 0.8 )
traits

}
\seealso{
\code{\link[=cov_trait]{cov_trait()}}, \code{\link[=sim_trait]{sim_trait()}}
}
