% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simsl.main.R
\name{pred.simsl}
\alias{pred.simsl}
\title{SIMSL prediction function}
\usage{
pred.simsl(simsl.obj, newx, newA = NULL, L = 30, type = "response",
  maximize = TRUE)
}
\arguments{
\item{simsl.obj}{a \code{simsl} object}

\item{newx}{a (n-by-p) matrix of new values for the covariates X at which predictions are to be made.}

\item{newA}{a (n-by-L) matrix of new values for the treatment A at which predictions are to be made.}

\item{L}{when \code{newA=NULL}, a value specifying the length of the grid of A at which predictions are to be made.}

\item{type}{the type of prediction required; the default "response" is on the scale of the response variable; the alternative "link" is on the scale of the linear predictors.}

\item{maximize}{the default is \code{TRUE}, assuming a larger value of the outcome is better; if \code{FALSE}, a smaller value is assumed to be prefered.}
}
\value{
\item{pred.new}{a (n-by-L) matrix of predicted values; each column represents a treatment option.}
\item{trt.rule}{a (n-by-1) vector of suggested treatment assignments}
}
\description{
This function makes predictions from an estimated SIMSL, given a (new) set of covariates.
The function returns a set of predicted outcomes given the treatment values in a dense grid of treatment levels for each individual, and a recommended treatment level (assuming a larger value of the outcome is better).
}
\seealso{
\code{simsl},\code{fit.simsl}
}
\author{
Park, Petkova, Tarpey, Ogden
}
