% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotextra.R
\name{cov_mat}
\alias{cov_mat}
\title{Extract various sigma matrices}
\usage{
cov_mat(obj, which = c("xy", "zy", "zw"), use_population = TRUE)
}
\arguments{
\item{obj}{A simrel object}

\item{which}{A character string to specify which covariance matrix to extract, possible values are "xy", "zy" and "zw"}

\item{use_population}{A boolean whether to use compute population values or to estimate from sample}
}
\value{
A matrix of covariances with column equals to the number of response and row equals to the number of predictors
}
\description{
Extract various sigma matrices
}
\examples{
set.seed(1983)
sobj <- multisimrel()
cov_mat(sobj, which = "xy", use_population = TRUE)
cov_mat(sobj, which = "xy", use_population = FALSE)
}
