% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gg_boxplot.R
\name{gg_boxplot_col_facet}
\alias{gg_boxplot_col_facet}
\title{Boxplot ggplot that is coloured and facetted.}
\usage{
gg_boxplot_col_facet(
  data,
  x_var,
  y_var = NULL,
  col_var,
  facet_var,
  pal = NULL,
  pal_na = "#7F7F7F",
  pal_rev = FALSE,
  alpha_fill = 0.2,
  alpha_line = 1,
  alpha_point = 1,
  size_line = 0.5,
  size_point = 1.5,
  size_width = 0.5,
  title = NULL,
  title_wrap = 80,
  subtitle = NULL,
  subtitle_wrap = 80,
  x_expand = ggplot2::waiver(),
  x_labels = snakecase::to_sentence_case,
  x_na_rm = FALSE,
  x_rev = FALSE,
  x_title = NULL,
  x_title_wrap = 50,
  y_balance = FALSE,
  y_breaks_n = 3,
  y_expand = c(0, 0),
  y_labels = scales::label_comma(),
  y_title = NULL,
  y_title_wrap = 50,
  y_zero = FALSE,
  y_zero_line = NULL,
  col_labels = snakecase::to_sentence_case,
  col_legend_none = FALSE,
  col_na_rm = FALSE,
  col_rev = FALSE,
  col_title = NULL,
  col_title_wrap = 25,
  facet_labels = snakecase::to_sentence_case,
  facet_na_rm = FALSE,
  facet_ncol = NULL,
  facet_nrow = NULL,
  facet_rev = FALSE,
  facet_scales = "fixed",
  caption = NULL,
  caption_wrap = 80,
  theme = gg_theme(gridlines_h = TRUE),
  stat = "boxplot",
  ymin_var = NULL,
  ylower_var = NULL,
  ymiddle_var = NULL,
  yupper_var = NULL,
  ymax_var = NULL
)
}
\arguments{
\item{data}{An ungrouped summarised tibble or dataframe generally in a structure to be transformed to boxplot statistics (or alternatively in a structure of summary boxplot statistics). Required input.}

\item{x_var}{Unquoted categorical variable to be on the x scale (i.e. character, factor, logical). Required input.}

\item{y_var}{Unquoted numeric variable to be on the y scale for when stat = "boxplot" is selected.}

\item{col_var}{Unquoted categorical variable to colour the fill of the boxes. Required input.}

\item{facet_var}{Unquoted categorical variable to facet the data by. Required input.}

\item{pal}{Character vector of hex codes.}

\item{pal_na}{The hex code or name of the NA colour to be used.}

\item{pal_rev}{Reverses the palette. Defaults to FALSE.}

\item{alpha_fill}{The opacity of the fill. Defaults to 0.2.}

\item{alpha_line}{The opacity of the outline. Defaults to 1.}

\item{alpha_point}{The opacity of the outlier points. Defaults to 1.}

\item{size_line}{The size of the outlines of boxplots. Defaults to 0.5.}

\item{size_point}{The size of the outlier points. Defaults to 1.5.}

\item{size_width}{Width of boxes. Defaults to 0.5.}

\item{title}{Title string.}

\item{title_wrap}{Number of characters to wrap the title to. Defaults to 75.}

\item{subtitle}{Subtitle string.}

\item{subtitle_wrap}{Number of characters to wrap the subtitle to. Defaults to 75.}

\item{x_expand}{A vector of range expansion constants used to add padding to the x scale, as per the ggplot2 expand argument in ggplot2 scales functions.}

\item{x_labels}{A function or named vector to modify x scale labels. If NULL, categorical variable labels are converted to sentence case. Use ggplot2::waiver() to keep x labels untransformed.}

\item{x_na_rm}{TRUE or FALSE of whether to include x_var NA values. Defaults to FALSE.}

\item{x_rev}{For a categorical x variable, TRUE or FALSE of whether the x variable variable is reversed. Defaults to FALSE.}

\item{x_title}{x scale title string. Defaults to NULL, which converts to sentence case with spaces. Use "" if you would like no title.}

\item{x_title_wrap}{Number of characters to wrap the x title to. Defaults to 50.}

\item{y_balance}{For a numeric y variable, add balance to the y scale so that zero is in the centre of the y scale.}

\item{y_breaks_n}{For a numeric or date x variable, the desired number of intervals on the x scale, as calculated by the pretty algorithm. Defaults to 4.}

\item{y_expand}{A vector of range expansion constants used to add padding to the y scale, as per the ggplot2 expand argument in ggplot2 scales functions.}

\item{y_labels}{A function or named vector to modify y scale labels. Use ggplot2::waiver() to keep y labels untransformed.}

\item{y_title}{y scale title string. Defaults to NULL, which converts to sentence case with spaces. Use "" if you would like no title.}

\item{y_title_wrap}{Number of characters to wrap the y title to. Defaults to 50.}

\item{y_zero}{For a numeric y variable, TRUE or FALSE of whether the minimum of the y scale is zero. Defaults to TRUE.}

\item{y_zero_line}{For a numeric y variable, TRUE or FALSE whether to add a zero reference line to the y scale. Defaults to TRUE if there are positive and negative values in y_var. Otherwise defaults to FALSE.}

\item{col_labels}{A function or named vector to modify colour scale labels. Defaults to snakecase::to_sentence_case. Use ggplot2::waiver() to keep colour labels untransformed.}

\item{col_legend_none}{TRUE or FALSE of whether to remove the legend.}

\item{col_na_rm}{TRUE or FALSE of whether to include col_var NA values. Defaults to FALSE.}

\item{col_rev}{TRUE or FALSE of whether the colour scale is reversed. Defaults to FALSE.}

\item{col_title}{Colour title string for the legend. Defaults to NULL, which converts to sentence case with spaces. Use "" if you would like no title.}

\item{col_title_wrap}{Number of characters to wrap the colour title to. Defaults to 25. Not applicable where mobile equals TRUE.}

\item{facet_labels}{A function or named vector to modify facet scale labels. Defaults to converting labels to sentence case. Use ggplot2::waiver() to keep facet labels untransformed.}

\item{facet_na_rm}{TRUE or FALSE of whether to include facet_var NA values. Defaults to FALSE.}

\item{facet_ncol}{The number of columns of facetted plots.}

\item{facet_nrow}{The number of rows of facetted plots.}

\item{facet_rev}{TRUE or FALSE of whether the facet variable variable is reversed. Defaults to FALSE.}

\item{facet_scales}{Whether facet_scales should be "fixed" across facets, "free" in both directions, or free in just one direction (i.e. "free_x" or "free_y"). Defaults to "fixed".}

\item{caption}{Caption title string.}

\item{caption_wrap}{Number of characters to wrap the caption to. Defaults to 80.}

\item{theme}{A ggplot2 theme.}

\item{stat}{String of "boxplot" or "identity". Defaults to "boxplot".}

\item{ymin_var}{Unquoted numeric variable for minimum of whisker on the y scale for when stat = "identity" is selected.}

\item{ylower_var}{Unquoted numeric variable for minimum of box on the y scale for when stat = "identity" is selected.}

\item{ymiddle_var}{Unquoted numeric variable for middle of box on the y scale for when stat = "identity" is selected.}

\item{yupper_var}{Unquoted numeric variable for maximum of box on the y scale for when stat = "identity" is selected.}

\item{ymax_var}{Unquoted numeric variable for maximum of whisker on the y scale for when stat = "identity" is selected.}
}
\value{
A ggplot object.
}
\description{
Boxplot ggplot that is facetted, but not coloured.
}
\examples{
library(simplevis)
library(palmerpenguins)

penguins \%>\% 
  dplyr::mutate(year = as.character(year)) \%>\% 
  gg_boxplot_col_facet(x_var = year, 
                     y_var = body_mass_g, 
                     col_var = sex, 
                     facet_var = species, 
                     col_na_rm = TRUE,
                     x_labels = function(x) stringr::str_sub(x, 3, 4))
                             
#For ggplotly, pipe in plotly::layout(boxmode = "group") layer
 
}
