% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/weights.R
\name{is_weighted}
\alias{is_weighted}
\title{Is the graph weighted?}
\usage{
is_weighted(graph)
}
\arguments{
\item{graph}{The graph.}
}
\description{
Is the graph weighted?
}
\examples{
G <- graph(
  data.frame(
    stringsAsFactors = FALSE,
    id = c("a", "b", "c", "d")
  ),
  data.frame(
    stringsAsFactors = FALSE,
    from   = c("a", "a", "b", "b", "c"),
    to     = c("b", "d", "d", "c", "a"),
    weight = c( 1 ,  2 ,  1 ,  3 ,  2 )
  )
)
is_weighted(G)

G2 <- graph(
  data.frame(
    stringsAsFactors = FALSE,
    id = c("a", "b", "c", "d")
  ),
  data.frame(
    stringsAsFactors = FALSE,
    from   = c("a", "a", "b", "b", "c"),
    to     = c("b", "d", "d", "c", "a")
  )
)
is_weighted(G2)
}

