% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trajectory-activities.R
\name{log_}
\alias{log_}
\alias{stop_if}
\title{Debugging}
\usage{
log_(.trj, message, level = 0, ..., tag)

stop_if(.trj, condition, ..., tag)
}
\arguments{
\item{.trj}{the trajectory object.}

\item{message}{the message to display, accepts either a string or a callable object
(a function) which must return a string.}

\item{level}{debugging level. The \code{message} will be printed if, and only if,
the \code{level} provided is less or equal to the \code{log_level} defined in the
simulation environment (see \code{\link{simmer}}).}

\item{...}{unused.}

\item{tag}{activity tag name to perform named rollbacks (see
\code{\link{rollback}}) or just to better identify your activities.}

\item{condition}{a boolean or a function returning a boolean.}
}
\value{
Returns the trajectory object.
}
\description{
Activities for displaying messages preceded by the simulation time and the
name of the arrival, and for setting conditional breakpoints.
}
\examples{
## log levels
traj <- trajectory() \%>\%
  log_("this is always printed") \%>\% # level = 0 by default
  log_("this is printed if `log_level>=1`", level = 1) \%>\%
  log_("this is printed if `log_level>=2`", level = 2)

simmer() \%>\%
  add_generator("dummy", traj, at(0)) \%>\%
  run() \%>\% invisible

simmer(log_level = 1) \%>\%
  add_generator("dummy", traj, at(0)) \%>\%
  run() \%>\% invisible

simmer(log_level = Inf) \%>\%
  add_generator("dummy", traj, at(0)) \%>\%
  run() \%>\% invisible

}
