% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trajectory-methods.R
\name{trajectory}
\alias{trajectory}
\title{Create a Trajectory}
\usage{
trajectory(name = "anonymous", verbose = FALSE)
}
\arguments{
\item{name}{the name of the trajectory.}

\item{verbose}{enable showing additional information.}
}
\value{
Returns an environment that represents the trajectory.
}
\description{
This method initialises a trajectory object, which comprises a chain of
activities that can be attached to a generator. See below for a complete list
of available activities by category.
}
\examples{
## create an empty trajectory
x <- trajectory("my trajectory")
x

## add some activities by chaining them
x <- x \%>\%
  log_("here I am!") \%>\%
  timeout(5) \%>\%
  log_("leaving!")
x

## join trajectories
x <- join(x, x)

## extract and replace
x[c(3, 4)] <- x[2]
x

}
\seealso{
Available activities by category:
\itemize{

\item Debugging: \code{\link{log_}}, \code{\link{stop_if}}

\item Delays: \code{\link{timeout}}, \code{\link{timeout_from_attribute}},
\code{\link{timeout_from_global}}

\item Arrival properties: \code{\link{set_attribute}}, \code{\link{set_global}},
\code{\link{set_prioritization}}

\item Interaction with resources: \code{\link{select}}, \code{\link{seize}},
\code{\link{release}}, \code{\link{release_all}}, \code{\link{seize_selected}},
\code{\link{release_selected}}, \code{\link{release_selected_all}},
\code{\link{set_capacity}}, \code{\link{set_queue_size}},
\code{\link{set_capacity_selected}}, \code{\link{set_queue_size_selected}}

\item Interaction with generators: \code{\link{activate}}, \code{\link{deactivate}},
\code{\link{set_trajectory}}, \code{\link{set_source}}

\item Branching: \code{\link{branch}}, \code{\link{clone}}, \code{\link{synchronize}}

\item Loops: \code{\link{rollback}}

\item Batching: \code{\link{batch}}, \code{\link{separate}}

\item Asynchronous programming: \code{\link{send}}, \code{\link{trap}},
\code{\link{untrap}}, \code{\link{wait}}

\item Reneging: \code{\link{leave}}, \code{\link{handle_unfinished}},
\code{\link{renege_in}}, \code{\link{renege_if}}, \code{\link{renege_abort}}

}

Manage trajectories:
\itemize{
\item Extract or Replace Parts of a Trajectory: \code{\link{Extract.trajectory}}
\item Join Trajectories: \code{\link{join}}
\item Number of Activities in a Trajectory: \code{\link{length.trajectory}},
\code{\link{get_n_activities}}
}
}
