% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/repeat_and_stack.R
\name{repeat_and_stack}
\alias{repeat_and_stack}
\title{Repeat an expression multiple times and (optionally) stack the results.}
\usage{
repeat_and_stack(n, expr, stack = TRUE)
}
\arguments{
\item{n}{Number of times to repeat the expression}

\item{expr}{An expression to be evaluated.}

\item{stack}{Logical value indicating whether to organize the results into a
\code{data.frame}.}
}
\value{
If \code{stack = TRUE} (the default), the results of each evaluation
  of \code{expr} will be stacked together using \code{rbind}. If \code{stack
  = FALSE}, a list of length \code{n} with entries corresponding to the
  output of each replication of \code{expr}.
}
\description{
Repeat an expression (usually involving random number
  generation) multiple times. Optionally, organize the results into a
  \code{data.frame} that stacks the output from all replications of the
  expression.
}
\examples{
repeat_and_stack(n = 3, data.frame(x = rexp(2)))

repeat_and_stack(n = 3, data.frame(x = rexp(2)), stack = FALSE)

}
