% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_relative_var.R
\name{calc_relative_var}
\alias{calc_relative_var}
\title{Calculate jack-knife Monte Carlo SE for variance estimators}
\usage{
calc_relative_var(
  data,
  estimates,
  var_estimates,
  criteria = c("relative bias", "relative mse", "relative rmse"),
  winz = Inf,
  var_winz = winz
)
}
\arguments{
\item{data}{data frame or tibble containing the simulation results.}

\item{estimates}{vector or name of column from \code{data} containing point
estimates.}

\item{var_estimates}{vector or name of column from \code{data} containing
variance estimates for point estimator in \code{estimates}.}

\item{criteria}{character or character vector indicating the performance
criteria to be calculated, with possible options \code{"relative bias"},
\code{"relative mse"}, and \code{"relative rmse"}.}

\item{winz}{numeric value for winsorization constant. If set to a finite
value, estimates will be winsorized at the constant multiple of the
inter-quartile range below the 25th percentile or above the 75th percentile
of the distribution. For instance, setting \code{winz = 3} will
truncate estimates that fall below P25 - 3 * IQR or above P75 + 3 * IQR.}

\item{var_winz}{numeric value for winsorization constant for the
variance estimates. If set to a finite value, variance estimates will be
winsorized at the constant multiple of the inter-quartile range below the
25th percentile or above the 75th percentile of the distribution. For
instance, setting \code{var_winz = 3} will truncate variance estimates
that fall below P25 - 3 * IQR or above P75 + 3 * IQR. By default
\code{var_winz} is set to the same constant as \code{winsorize}.}
}
\value{
A tibble containing the number of simulation iterations, performance
  criteria estimate(s) and the associated MCSE.
}
\description{
Calculates relative bias, mean squared error (relative mse), and
  root mean squared error (relative rmse)  of variance estimators. The
  function also calculates the associated jack-knife Monte Carlo standard
  errors.
}
\examples{
calc_relative_var(data = alpha_res, estimates = A, var_estimates = Var_A)

}
