% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_relative_var.R
\name{calc_relative_var}
\alias{calc_relative_var}
\title{Calculate jack-knife Monte Carlo SE for variance estimators}
\usage{
calc_relative_var(
  res_dat,
  estimates,
  var_estimates,
  perfm_criteria = c("relative bias", "relative mse", "relative rmse")
)
}
\arguments{
\item{res_dat}{data frame or tibble containing the simulation results.}

\item{estimates}{name of the column containing the estimates.}

\item{var_estimates}{name of the column containing the variance estimates.}

\item{perfm_criteria}{character or character vector indicating the performance criteria to be calculated.}
}
\value{
A tibble containing the number of simulation iterations, performance criteria estimate(s)
and the associated MCSE.
}
\description{
Calculates relative bias, mean squared error (relative mse), and root mean
squared error (relative rmse)  of variance estimators.
The function also calculates the associated jack-knife Monte Carlo standard errors.
}
\examples{
calc_relative_var(res_dat = alpha_res, estimates = A, var_estimates = Var_A)

}
