% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{optimize_cor_mat}
\alias{optimize_cor_mat}
\title{Find initial correlation matrix for NORTA from target correlation}
\usage{
optimize_cor_mat(
  cor_target,
  dist,
  ensure_cor_mat = TRUE,
  conv_norm_type = "O",
  return_diagnostics = FALSE,
  ...
)
}
\arguments{
\item{cor_target}{Target correlation matrix.}

\item{dist}{List of functions of marginal distributions for simulated variables.
Must have the same length as the specified correlation matrix
(\code{cor_target}), and the order of the entries must correspond to the
variables in the correlation matrix. See \code{\link{simdesign_norta}} for
details of the specification of the marginal distributions.}

\item{ensure_cor_mat}{if TRUE, this function ensures that the optimized matrix is a proper
correlation matrix by ensuring positive definitiness. If FALSE, the
optimized matrix is returned as is.}

\item{conv_norm_type}{Metric to be used to find closest positive definite matrix to optimal matrix,
used if \code{ensure_cor_mat} is TRUE.
Passed to \code{\link[Matrix:nearPD]{Matrix::nearPD}}.}

\item{return_diagnostics}{TRUE to return additional diagnostics of the optimization procedure, see
below.}

\item{...}{Additional parameters passed to \code{\link{optimize_cor_for_pair}}.}
}
\value{
If \code{return_diagnostics} is FALSE, a correlation matrix to be used in the
definition of a \code{\link{simdesign_norta}} object. If TRUE, then a list
with two entries: \code{cor_mat} containing the correlation matrix, and
\code{convergence} containing a list of objects returned by the individual
optimisation problems from \code{\link[stats:uniroot]{stats::uniroot}}.
}
\description{
This function can be used to find a suitable correlation matrix to be used
for simulating initial multivariate normal data in a NORTA based simulation
design (see \code{\link{simdesign_norta}}).
}
\details{
This function first finds a suitable correlation matrix for the underlying
multivariate normal data used in the NORTA procedure. It does so by
solving k*(k-1) univariable optimisation problems (where k is the number
of variables). In case the result is not a positive-definite matrix, the
nearest positive-definite matrix is found according to the user specified
metric using \code{\link[Matrix:nearPD]{Matrix::nearPD}}.
See e.g. Ghosh and Henderson (2003) for an overview of the procedure.
}
\references{
Ghosh, S. and Henderson, S. G. (2003) \emph{Behavior of the
NORTA method for correlated random vector generation as the dimension
increases}. ACM Transactions on Modeling and Computer Simulation.
}
\seealso{
\code{\link{simdesign_norta}}
}
