% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simaerep.R
\name{sim_sites}
\alias{sim_sites}
\title{Calculate prob_lower and poisson.test pvalue for study sites.}
\usage{
sim_sites(
  df_site,
  df_visit,
  r = 1000,
  poisson_test = TRUE,
  prob_lower = TRUE,
  progress = TRUE,
  check = TRUE,
  under_only = TRUE
)
}
\arguments{
\item{df_site}{dataframe created by \code{\link[simaerep]{site_aggr}}}

\item{df_visit}{dataframe, created by \code{\link[simaerep]{sim_sites}}}

\item{r}{integer, denotes number of simulations, default = 1000}

\item{poisson_test}{logical, calculates poisson.test pvalue}

\item{prob_lower}{logical, calculates probability for getting a lower value}

\item{progress}{logical, display progress bar, Default = TRUE}

\item{check, }{logical, perform data check and attempt repair with}

\item{under_only}{compute under-reporting probabilities only, default = TRUE
\link[=check_df_visit]{check_df_visit()}, computationally expensive on large data
sets. Default: TRUE}
}
\value{
dataframe with the following columns:
\describe{
\item{\strong{study_id}}{study identification}
\item{\strong{site_number}}{site identification}
\item{\strong{n_pat}}{number of patients at site}
\item{\strong{visit_med75}}{median(max(visit)) * 0.75}
\item{\strong{n_pat_with_med75}}{number of patients at site with med75}
\item{\strong{mean_ae_site_med75}}{mean AE at visit_med75 site level}
\item{\strong{mean_ae_study_med75}}{mean AE at visit_med75 study level}
\item{\strong{n_pat_with_med75_study}}{number of patients at study with med75 excl. site}
\item{\strong{pval}}{p-value as returned by \code{\link[stats]{poisson.test}}}
\item{\strong{prob_low}}{bootstrapped probability for having mean_ae_site_med75 or lower}
}
}
\description{
Collects the number of AEs of all eligible patients that
meet visit_med75 criteria of site. Then  calculates poisson.test pvalue and
bootstrapped probability of having a lower mean value.
}
\examples{
df_visit <- sim_test_data_study(
   n_pat = 100,
   n_sites = 5,
   frac_site_with_ur = 0.4,
   ur_rate = 0.2
)

df_visit$study_id <- "A"

df_site <- site_aggr(df_visit)

df_sim_sites <- sim_sites(df_site, df_visit, r = 100)

df_sim_sites \%>\%
 knitr::kable(digits = 2)
}
\seealso{
\code{\link[simaerep]{sim_sites}},
\code{\link[simaerep]{site_aggr}},
\code{\link[simaerep]{pat_pool}},
\code{\link[simaerep]{prob_lower_site_ae_vs_study_ae}},
\code{\link[simaerep]{poiss_test_site_ae_vs_study_ae}},
\code{\link[simaerep]{sim_sites}},
\code{\link[simaerep]{prep_for_sim}}
}
