% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/densify.R
\name{simCluster}
\alias{simCluster}
\title{Generate clustered regions}
\usage{
simCluster(S, CL, cond = list(eps = 1e-06, minSize = 1L),
  do.rsa = FALSE, verbose = FALSE, pl = 0L)
}
\arguments{
\item{S}{(non-overlapping) geometry objects system}

\item{CL}{cluster regions, i.e. objects of class '\code{spheres}', possibly overlapping}

\item{cond}{conditioning object for cluster algorithm, see details}

\item{do.rsa}{optional, whether to apply \code{\link{rsa}} algorithm to cluster spheres}

\item{verbose}{optional, verbose output, \code{verbose=FALSE} (default)}

\item{pl}{integer, \code{pl>0} for printing information}
}
\value{
a list of the following element:
					    \itemize{
						\item{id}{ numeric vector of ids of including spheroids }
							\item{center}{ the center of enclosing ball }
							\item{r}{ the radius}
							\item{interior}{ equals to \code{0} if any of the enclosed ball objects
								hit the boundaries of the simulation box and equals \code{1} otherwise}
						}
}
\description{
Construct regions of clustered objects
}
\details{
The function takes a non-overlapping system of spheres, cylinders, spheroids of type "\code{prolate}" or "\code{oblate}
and a random ball configuration \code{CL} of class "\code{spheres}" which defines clustered regions of the objects given
in \code{S} according to the minimum required distance \code{eps} between these objects and a number of objects required
in that region by \code{minSize} in the list \code{cond}. The function \code{\link{rsa}} is internally called if
\code{do.rsa=TRUE} in order to make these cluster regions non-overlapping.
}
\examples{
\dontrun{

## Simulate and densify particle system
## densify and include a secondary phase

library(unfoldr)

## Unless MS-Windows platform	
# library(parallel)
# options(simLife.mc=2L)
 
# simulation box either this kind of list
# or use object spatstat::box3 
box <- list("xrange"=c(0,3),"yrange"=c(0,3),"zrange"=c(0,9))

# parameter for spheroids simulation 
theta <- list("size"=list(0.25),"shape"=list("s"=0.25), "orientation"=list("kappa"=1))

# for ease of use: constant size particles
S <- simPoissonSystem(theta,lam=15,size="const",type="prolate",
			orientation="rbetaiso",box=box,mu=c(0,1,0),pl=1,label="P")
	
## 2nd. phase (ferrit)	
param <- list("size"=list(0.075), "shape"=list("s"=0.75))
F <- simPoissonSystem(param,lam=2,size="const",type="prolate",
		box=box,mu=c(0,1,0),pl=1,label="P")

# apply RSA, this may take some 
RSA <- rsa(S,F,verbose=TRUE)

## show 3D spheroids (non-overlapping)
# library(rgl)
# cols <- c("#0000FF","#00FF00","#FF0000","#FF00FF","#FFFF00","#00FFFF")
# spheroids3d(RSA[1:length(S)], box, col=cols)	
# spheroids3d(RSA[length(S):(length(S)+length(F))], box, col="gray")

## construct clusters
CL <- simPoissonSystem(list("size"=list(0.35)), lam=0.1, size="const",
			type="spheres", box=box, pl=1, label="F")

CLUST <- simCluster(RSA, CL, verbose=TRUE)
cat("cluster length: ",length(CLUST),"\\n")

## show cluster regions
# library(rgl)
# open3d()
# X <- do.call(rbind,lapply(CLUST, function(x) c(x$center,x$r)))
# invisible(lapply(CLUST, function(x) rgl::spheres3d(X[,1:3],radius=X[,4],col="gray",alpha=0.2)))
# cols <- c("#0000FF","#00FF00","#FF0000","#FF00FF","#FFFF00","#00FFFF")
# invisible(lapply(CLUST, function(x) spheroids3d(RSA[x$id],box,col=cols)))

# some controls for 'GenSA'
ctrl <- list(threshold.stop=0.01,max.call=10000)
# densify region to clustered particles
RET <- densifyCluster(RSA, CLUST, ctrl, weight=100, cores = 1L, cl = NULL)	

S <- RET$S
CL <- RET$cluster

## show densified clusters 
# library(rgl)
# open3d()
# X <- do.call(rbind,lapply(CLUST, function(x) c(x$center,x$r)))
# invisible(lapply(CLUST, function(x)
# rgl::spheres3d(x=X[,1:3],radius=X[,4],col="gray",alpha=0.2)))
# invisible(lapply(CL, function(x) { spheroids3d(x, box, col=cols) }))
	
}	
}
\author{
M. Baaske
}
