% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/silp.R
\name{silp}
\alias{silp}
\title{silp}
\usage{
silp(model, data, center = "double", tau.eq = F, npd = F, ...)
}
\arguments{
\item{model}{A \code{lavaan} syntax model with extension. The notation ":" implies interaction between two variables (see Example).}

\item{data}{The dataset for \code{lavaan} SEM.}

\item{center}{Character. Whether single or double mean centering is used for the product indicator. Default is "double".}

\item{tau.eq}{Logical. Specifies the type of reliability used to estimate error variance. If \code{TRUE}, Cronbach's alpha reliability is used.
If \code{FALSE}, omega reliability is used. Default is \code{FALSE}.}

\item{npd}{Logical. Specifies the type of input used in \code{lavaan} SEM. Default is \code{FALSE} for raw data or \code{TRUE} for a covariance matrix.
Applying a covariance matrix can resolve problems of a non-positive definite covariance matrix.
If \code{TRUE}, \code{resilp} should be used to obtain reliable inference.}

\item{...}{Other parameters passed to the \code{lavaan} SEM function.#'}
}
\value{
An "Silp" class object.
}
\description{
This function extends the \code{lavaan} function, allowing users to define moderation effects using the symbol ":".
The RAPI method is used to estimate moderation effects.
}
\examples{
n_obs = 100
corr = 0.1
effect = 0.12
ld = c(1,1,1,1)
alp = 0.9
data = generate_data(n_obs, corr, effect, ld, alp)
model = "
  fy =~ y1 + y2 + y3 + y4
  fx =~ x1 + x2 + x3 + x4
  fz =~ z1 + z2 + z3 + z4
  fy ~  fx + fz + fx:fz
"
silp(model, data)
}
