% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_genome_annotation.R
\name{get_genome_annotation}
\alias{get_genome_annotation}
\title{Get Genome Annotation}
\usage{
get_genome_annotation(
  data_type = c("chr_size", "centro_loc", "cytobands", "transcript"),
  chrs = paste0("chr", c(1:22, "X", "Y")),
  genome_build = c("hg19", "hg38", "mm10")
)
}
\arguments{
\item{data_type}{'chr_size' for chromosome size,
'centro_loc' for location of centromeres,
'cytobands' for location of chromosome cytobands
and 'transcript' for location of transcripts.}

\item{chrs}{chromosomes start with 'chr'}

\item{genome_build}{one of 'hg19', 'hg38'}
}
\value{
a \code{data.frame} containing annotation data
}
\description{
Get Genome Annotation
}
\examples{
df1 <- get_genome_annotation()
df1

df2 <- get_genome_annotation(genome_build = "hg38")
df2

df3 <- get_genome_annotation(data_type = "centro_loc")
df3

df4 <- get_genome_annotation(data_type = "centro_loc", genome_build = "hg38")
df4

df5 <- get_genome_annotation(data_type = "cytobands")
df5

df6 <- get_genome_annotation(data_type = "cytobands", genome_build = "hg38")
df6
}
